/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;

final class FlowableZipIterable$ZipIterableSubscriber<T, U, V>
implements Yy,
FlowableSubscriber<T> {
    final Yx<? super V> actual;
    final Iterator<U> iterator;
    final BiFunction<? super T, ? super U, ? extends V> zipper;
    Yy s;
    boolean done;

    FlowableZipIterable$ZipIterableSubscriber(Yx<? super V> actual, Iterator<U> iterator, BiFunction<? super T, ? super U, ? extends V> zipper) {
        this.actual = actual;
        this.iterator = iterator;
        this.zipper = zipper;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        boolean b2;
        V v2;
        U u2;
        if (this.done) {
            return;
        }
        try {
            u2 = ObjectHelper.requireNonNull(this.iterator.next(), "The iterator returned a null value");
        }
        catch (Throwable e2) {
            this.error(e2);
            return;
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.zipper.apply(t2, u2), "The zipper function returned a null value");
        }
        catch (Throwable e3) {
            this.error(e3);
            return;
        }
        this.actual.onNext(v2);
        try {
            b2 = this.iterator.hasNext();
        }
        catch (Throwable e4) {
            this.error(e4);
            return;
        }
        if (!b2) {
            this.done = true;
            this.s.cancel();
            this.actual.onComplete();
        }
    }

    void error(Throwable e2) {
        Exceptions.throwIfFatal(e2);
        this.done = true;
        this.s.cancel();
        this.actual.onError(e2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    @Override
    public void request(long n2) {
        this.s.request(n2);
    }

    @Override
    public void cancel() {
        this.s.cancel();
    }
}

