/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.FlowableZip$ZipCoordinator;
import io.reactivex.internal.subscriptions.EmptySubscription;

public final class FlowableZip<T, R>
extends Flowable<R> {
    final Yw<? extends T>[] sources;
    final Iterable<? extends Yw<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;
    final int bufferSize;
    final boolean delayError;

    public FlowableZip(Yw<? extends T>[] sources, Iterable<? extends Yw<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.zipper = zipper;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Yx<? super R> s2) {
        Yw<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Yw[8];
            for (Yw<? extends T> yw2 : this.sourcesIterable) {
                if (count == sources.length) {
                    Yw[] b2 = new Yw[count + (count >> 2)];
                    System.arraycopy(sources, 0, b2, 0, count);
                    sources = b2;
                }
                sources[count++] = yw2;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s2);
            return;
        }
        FlowableZip$ZipCoordinator<? extends T, R> coordinator = new FlowableZip$ZipCoordinator<T, R>(s2, this.zipper, count, this.bufferSize, this.delayError);
        s2.onSubscribe(coordinator);
        coordinator.subscribe(sources, count);
    }
}

