/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableZip$ZipCoordinator;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableZip$ZipSubscriber<T, R>
extends AtomicReference<Yy>
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -4627193790118206028L;
    final FlowableZip$ZipCoordinator<T, R> parent;
    final int prefetch;
    final int limit;
    SimpleQueue<T> queue;
    long produced;
    volatile boolean done;
    int sourceMode;

    FlowableZip$ZipSubscriber(FlowableZip$ZipCoordinator<T, R> parent, int prefetch) {
        this.parent = parent;
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription f2 = (QueueSubscription)s2;
                int m2 = f2.requestFusion(7);
                if (m2 == 1) {
                    this.sourceMode = m2;
                    this.queue = f2;
                    this.done = true;
                    this.parent.drain();
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = m2;
                    this.queue = f2;
                    s2.request(this.prefetch);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.prefetch);
            s2.request(this.prefetch);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.sourceMode != 2) {
            this.queue.offer(t2);
        }
        this.parent.drain();
    }

    @Override
    public void onError(Throwable t2) {
        this.parent.error(this, t2);
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.parent.drain();
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    @Override
    public void request(long n2) {
        if (this.sourceMode != 1) {
            long p2 = this.produced + n2;
            if (p2 >= (long)this.limit) {
                this.produced = 0L;
                ((Yy)this.get()).request(p2);
            } else {
                this.produced = p2;
            }
        }
    }
}

