/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.operators.flowable.FlowableWithLatestFromMany$WithLatestInnerSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.HalfSerializer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class FlowableWithLatestFromMany$WithLatestFromSubscriber<T, R>
extends AtomicInteger
implements Yy,
ConditionalSubscriber<T> {
    private static final long serialVersionUID = 1577321883966341961L;
    final Yx<? super R> actual;
    final Function<? super Object[], R> combiner;
    final FlowableWithLatestFromMany$WithLatestInnerSubscriber[] subscribers;
    final AtomicReferenceArray<Object> values;
    final AtomicReference<Yy> s;
    final AtomicLong requested;
    final AtomicThrowable error;
    volatile boolean done;

    FlowableWithLatestFromMany$WithLatestFromSubscriber(Yx<? super R> actual, Function<? super Object[], R> combiner, int n2) {
        this.actual = actual;
        this.combiner = combiner;
        FlowableWithLatestFromMany$WithLatestInnerSubscriber[] s2 = new FlowableWithLatestFromMany$WithLatestInnerSubscriber[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            s2[i2] = new FlowableWithLatestFromMany$WithLatestInnerSubscriber(this, i2);
        }
        this.subscribers = s2;
        this.values = new AtomicReferenceArray(n2);
        this.s = new AtomicReference();
        this.requested = new AtomicLong();
        this.error = new AtomicThrowable();
    }

    void subscribe(Yw<?>[] others, int n2) {
        FlowableWithLatestFromMany$WithLatestInnerSubscriber[] subscribers = this.subscribers;
        AtomicReference<Yy> s2 = this.s;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (SubscriptionHelper.isCancelled(s2.get())) {
                return;
            }
            others[i2].subscribe(subscribers[i2]);
        }
    }

    @Override
    public void onSubscribe(Yy s2) {
        SubscriptionHelper.deferredSetOnce(this.s, this.requested, s2);
    }

    @Override
    public void onNext(T t2) {
        if (!this.tryOnNext(t2) && !this.done) {
            this.s.get().request(1L);
        }
    }

    @Override
    public boolean tryOnNext(T t2) {
        R v2;
        if (this.done) {
            return false;
        }
        AtomicReferenceArray<Object> ara = this.values;
        int n2 = ara.length();
        Object[] objects = new Object[n2 + 1];
        objects[0] = t2;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object o2 = ara.get(i2);
            if (o2 == null) {
                return false;
            }
            objects[i2 + 1] = o2;
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.combiner.apply((Object[])objects), "The combiner returned a null value");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.cancel();
            this.onError(ex2);
            return false;
        }
        HalfSerializer.onNext(this.actual, v2, (AtomicInteger)this, this.error);
        return true;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.cancelAllBut(-1);
        HalfSerializer.onError(this.actual, t2, (AtomicInteger)this, this.error);
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.cancelAllBut(-1);
            HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
        }
    }

    @Override
    public void request(long n2) {
        SubscriptionHelper.deferredRequest(this.s, this.requested, n2);
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this.s);
        for (FlowableWithLatestFromMany$WithLatestInnerSubscriber s2 : this.subscribers) {
            s2.dispose();
        }
    }

    void innerNext(int index, Object o2) {
        this.values.set(index, o2);
    }

    void innerError(int index, Throwable t2) {
        this.done = true;
        SubscriptionHelper.cancel(this.s);
        this.cancelAllBut(index);
        HalfSerializer.onError(this.actual, t2, (AtomicInteger)this, this.error);
    }

    void innerComplete(int index, boolean nonEmpty) {
        if (!nonEmpty) {
            this.done = true;
            SubscriptionHelper.cancel(this.s);
            this.cancelAllBut(index);
            HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
        }
    }

    void cancelAllBut(int index) {
        FlowableWithLatestFromMany$WithLatestInnerSubscriber[] subscribers = this.subscribers;
        for (int i2 = 0; i2 < subscribers.length; ++i2) {
            if (i2 == index) continue;
            subscribers[i2].dispose();
        }
    }
}

