/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.processors.UnicastProcessor;
import java.util.concurrent.TimeUnit;

final class FlowableWindowTimed$WindowExactUnboundedSubscriber<T>
extends QueueDrainSubscriber<T, Object, Flowable<T>>
implements Yy,
FlowableSubscriber<T>,
Runnable {
    final long timespan;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    Yy s;
    UnicastProcessor<T> window;
    final SequentialDisposable timer = new SequentialDisposable();
    static final Object NEXT = new Object();
    volatile boolean terminated;

    FlowableWindowTimed$WindowExactUnboundedSubscriber(Yx<? super Flowable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize) {
        super(actual, new MpscLinkedQueue());
        this.timespan = timespan;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.window = UnicastProcessor.create(this.bufferSize);
            Yx a2 = this.actual;
            a2.onSubscribe(this);
            long r2 = this.requested();
            if (r2 != 0L) {
                a2.onNext(this.window);
                if (r2 != Long.MAX_VALUE) {
                    this.produced(1L);
                }
            } else {
                this.cancelled = true;
                s2.cancel();
                a2.onError(new MissingBackpressureException("Could not deliver first window due to lack of requests."));
                return;
            }
            if (!this.cancelled && this.timer.replace(this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit))) {
                s2.request(Long.MAX_VALUE);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.terminated) {
            return;
        }
        if (this.fastEnter()) {
            this.window.onNext(t2);
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(NotificationLite.next(t2));
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onError(t2);
        this.dispose();
    }

    @Override
    public void onComplete() {
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        this.actual.onComplete();
        this.dispose();
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void dispose() {
        DisposableHelper.dispose(this.timer);
    }

    @Override
    public void run() {
        if (this.cancelled) {
            this.terminated = true;
            this.dispose();
        }
        this.queue.offer(NEXT);
        if (this.enter()) {
            this.drainLoop();
        }
    }

    void drainLoop() {
        SimplePlainQueue q2 = this.queue;
        Yx a2 = this.actual;
        UnicastProcessor w2 = this.window;
        int missed = 1;
        while (true) {
            boolean term = this.terminated;
            boolean d2 = this.done;
            Object o2 = q2.poll();
            if (d2 && (o2 == null || o2 == NEXT)) {
                this.window = null;
                q2.clear();
                this.dispose();
                Throwable err = this.error;
                if (err != null) {
                    w2.onError(err);
                } else {
                    w2.onComplete();
                }
                return;
            }
            if (o2 != null) {
                if (o2 == NEXT) {
                    w2.onComplete();
                    if (!term) {
                        w2 = UnicastProcessor.create(this.bufferSize);
                        this.window = w2;
                        long r2 = this.requested();
                        if (r2 != 0L) {
                            a2.onNext(w2);
                            if (r2 == Long.MAX_VALUE) continue;
                            this.produced(1L);
                            continue;
                        }
                        this.window = null;
                        this.queue.clear();
                        this.s.cancel();
                        this.dispose();
                        a2.onError(new MissingBackpressureException("Could not deliver first window due to lack of requests."));
                        return;
                    }
                    this.s.cancel();
                    continue;
                }
                w2.onNext(NotificationLite.getValue(o2));
                continue;
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }
}

