/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.flowable.FlowableWindowBoundarySelector$OperatorWindowBoundaryCloseSubscriber;
import io.reactivex.internal.operators.flowable.FlowableWindowBoundarySelector$OperatorWindowBoundaryOpenSubscriber;
import io.reactivex.internal.operators.flowable.FlowableWindowBoundarySelector$WindowOperation;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableWindowBoundarySelector$WindowBoundaryMainSubscriber<T, B, V>
extends QueueDrainSubscriber<T, Object, Flowable<T>>
implements Yy {
    final Yw<B> open;
    final Function<? super B, ? extends Yw<V>> close;
    final int bufferSize;
    final CompositeDisposable resources;
    Yy s;
    final AtomicReference<Disposable> boundary = new AtomicReference();
    final List<UnicastProcessor<T>> ws;
    final AtomicLong windows = new AtomicLong();

    FlowableWindowBoundarySelector$WindowBoundaryMainSubscriber(Yx<? super Flowable<T>> actual, Yw<B> open, Function<? super B, ? extends Yw<V>> close, int bufferSize) {
        super(actual, new MpscLinkedQueue());
        this.open = open;
        this.close = close;
        this.bufferSize = bufferSize;
        this.resources = new CompositeDisposable();
        this.ws = new ArrayList<UnicastProcessor<T>>();
        this.windows.lazySet(1L);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            if (this.cancelled) {
                return;
            }
            FlowableWindowBoundarySelector$OperatorWindowBoundaryOpenSubscriber os2 = new FlowableWindowBoundarySelector$OperatorWindowBoundaryOpenSubscriber(this);
            if (this.boundary.compareAndSet(null, os2)) {
                this.windows.getAndIncrement();
                s2.request(Long.MAX_VALUE);
                this.open.subscribe(os2);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.fastEnter()) {
            for (UnicastProcessor<T> w2 : this.ws) {
                w2.onNext(t2);
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(NotificationLite.next(t2));
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        if (this.windows.decrementAndGet() == 0L) {
            this.resources.dispose();
        }
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        if (this.windows.decrementAndGet() == 0L) {
            this.resources.dispose();
        }
        this.actual.onComplete();
    }

    void error(Throwable t2) {
        this.s.cancel();
        this.resources.dispose();
        DisposableHelper.dispose(this.boundary);
        this.actual.onError(t2);
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    void dispose() {
        this.resources.dispose();
        DisposableHelper.dispose(this.boundary);
    }

    void drainLoop() {
        SimplePlainQueue q2 = this.queue;
        Yx a2 = this.actual;
        List<UnicastProcessor<T>> ws2 = this.ws;
        int missed = 1;
        block2: while (true) {
            boolean empty;
            boolean d2 = this.done;
            Object o2 = q2.poll();
            boolean bl2 = empty = o2 == null;
            if (d2 && empty) {
                this.dispose();
                Throwable e2 = this.error;
                if (e2 != null) {
                    for (UnicastProcessor<T> w2 : ws2) {
                        w2.onError(e2);
                    }
                } else {
                    for (UnicastProcessor<T> w3 : ws2) {
                        w3.onComplete();
                    }
                }
                ws2.clear();
                return;
            }
            if (!empty) {
                UnicastProcessor w4;
                if (o2 instanceof FlowableWindowBoundarySelector$WindowOperation) {
                    Yw<V> p2;
                    FlowableWindowBoundarySelector$WindowOperation wo2 = (FlowableWindowBoundarySelector$WindowOperation)o2;
                    w4 = wo2.w;
                    if (w4 != null) {
                        if (!ws2.remove(wo2.w)) continue;
                        wo2.w.onComplete();
                        if (this.windows.decrementAndGet() != 0L) continue;
                        this.dispose();
                        return;
                    }
                    if (this.cancelled) continue;
                    w4 = UnicastProcessor.create(this.bufferSize);
                    long r2 = this.requested();
                    if (r2 != 0L) {
                        ws2.add(w4);
                        a2.onNext(w4);
                        if (r2 != Long.MAX_VALUE) {
                            this.produced(1L);
                        }
                    } else {
                        this.cancelled = true;
                        a2.onError(new MissingBackpressureException("Could not deliver new window due to lack of requests"));
                        continue;
                    }
                    try {
                        p2 = ObjectHelper.requireNonNull(this.close.apply(wo2.open), "The publisher supplied is null");
                    }
                    catch (Throwable e3) {
                        this.cancelled = true;
                        a2.onError(e3);
                        continue;
                    }
                    FlowableWindowBoundarySelector$OperatorWindowBoundaryCloseSubscriber cl2 = new FlowableWindowBoundarySelector$OperatorWindowBoundaryCloseSubscriber(this, w4);
                    if (!this.resources.add(cl2)) continue;
                    this.windows.getAndIncrement();
                    p2.subscribe(cl2);
                    continue;
                }
                Iterator<UnicastProcessor<T>> iterator = ws2.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    w4 = iterator.next();
                    w4.onNext(NotificationLite.getValue(o2));
                }
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }

    @Override
    public boolean accept(Yx<? super Flowable<T>> a2, Object v2) {
        return false;
    }

    void open(B b2) {
        this.queue.offer(new FlowableWindowBoundarySelector$WindowOperation(null, b2));
        if (this.enter()) {
            this.drainLoop();
        }
    }

    void close(FlowableWindowBoundarySelector$OperatorWindowBoundaryCloseSubscriber<T, V> w2) {
        this.resources.delete(w2);
        this.queue.offer(new FlowableWindowBoundarySelector$WindowOperation(w2.w, null));
        if (this.enter()) {
            this.drainLoop();
        }
    }
}

