/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.flowable.FlowableWindowBoundary$WindowBoundaryInnerSubscriber;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableWindowBoundary$WindowBoundaryMainSubscriber<T, B>
extends QueueDrainSubscriber<T, Object, Flowable<T>>
implements Yy {
    final Yw<B> other;
    final int bufferSize;
    Yy s;
    final AtomicReference<Disposable> boundary = new AtomicReference();
    UnicastProcessor<T> window;
    static final Object NEXT = new Object();
    final AtomicLong windows = new AtomicLong();

    FlowableWindowBoundary$WindowBoundaryMainSubscriber(Yx<? super Flowable<T>> actual, Yw<B> other, int bufferSize) {
        super(actual, new MpscLinkedQueue());
        this.other = other;
        this.bufferSize = bufferSize;
        this.windows.lazySet(1L);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            Yx a2 = this.actual;
            a2.onSubscribe(this);
            if (this.cancelled) {
                return;
            }
            UnicastProcessor w2 = UnicastProcessor.create(this.bufferSize);
            long r2 = this.requested();
            if (r2 != 0L) {
                a2.onNext(w2);
                if (r2 != Long.MAX_VALUE) {
                    this.produced(1L);
                }
            } else {
                a2.onError(new MissingBackpressureException("Could not deliver first window due to lack of requests"));
                return;
            }
            this.window = w2;
            FlowableWindowBoundary$WindowBoundaryInnerSubscriber inner = new FlowableWindowBoundary$WindowBoundaryInnerSubscriber(this);
            if (this.boundary.compareAndSet(null, inner)) {
                this.windows.getAndIncrement();
                s2.request(Long.MAX_VALUE);
                this.other.subscribe(inner);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.fastEnter()) {
            UnicastProcessor<T> w2 = this.window;
            w2.onNext(t2);
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            this.queue.offer(NotificationLite.next(t2));
            if (!this.enter()) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        if (this.windows.decrementAndGet() == 0L) {
            DisposableHelper.dispose(this.boundary);
        }
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.enter()) {
            this.drainLoop();
        }
        if (this.windows.decrementAndGet() == 0L) {
            DisposableHelper.dispose(this.boundary);
        }
        this.actual.onComplete();
    }

    @Override
    public void request(long n2) {
        this.requested(n2);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    void drainLoop() {
        SimplePlainQueue q2 = this.queue;
        Yx a2 = this.actual;
        int missed = 1;
        UnicastProcessor w2 = this.window;
        while (true) {
            boolean empty;
            boolean d2 = this.done;
            Object o2 = q2.poll();
            boolean bl2 = empty = o2 == null;
            if (d2 && empty) {
                DisposableHelper.dispose(this.boundary);
                Throwable e2 = this.error;
                if (e2 != null) {
                    w2.onError(e2);
                } else {
                    w2.onComplete();
                }
                return;
            }
            if (!empty) {
                if (o2 == NEXT) {
                    w2.onComplete();
                    if (this.windows.decrementAndGet() == 0L) {
                        DisposableHelper.dispose(this.boundary);
                        return;
                    }
                    if (this.cancelled) continue;
                    w2 = UnicastProcessor.create(this.bufferSize);
                    long r2 = this.requested();
                    if (r2 != 0L) {
                        this.windows.getAndIncrement();
                        a2.onNext(w2);
                        if (r2 != Long.MAX_VALUE) {
                            this.produced(1L);
                        }
                    } else {
                        this.cancelled = true;
                        a2.onError(new MissingBackpressureException("Could not deliver new window due to lack of requests"));
                        continue;
                    }
                    this.window = w2;
                    continue;
                }
                w2.onNext(NotificationLite.getValue(o2));
                continue;
            }
            if ((missed = this.leave(-missed)) == 0) break;
        }
    }

    void next() {
        this.queue.offer(NEXT);
        if (this.enter()) {
            this.drainLoop();
        }
    }

    @Override
    public boolean accept(Yx<? super Flowable<T>> a2, Object v2) {
        return false;
    }
}

