/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableWindow$WindowOverlapSubscriber<T>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T>,
Runnable {
    private static final long serialVersionUID = 2428527070996323976L;
    final Yx<? super Flowable<T>> actual;
    final SpscLinkedArrayQueue<UnicastProcessor<T>> queue;
    final long size;
    final long skip;
    final ArrayDeque<UnicastProcessor<T>> windows;
    final AtomicBoolean once;
    final AtomicBoolean firstRequest;
    final AtomicLong requested;
    final AtomicInteger wip;
    final int bufferSize;
    long index;
    long produced;
    Yy s;
    volatile boolean done;
    Throwable error;
    volatile boolean cancelled;

    FlowableWindow$WindowOverlapSubscriber(Yx<? super Flowable<T>> actual, long size, long skip, int bufferSize) {
        super(1);
        this.actual = actual;
        this.size = size;
        this.skip = skip;
        this.queue = new SpscLinkedArrayQueue(bufferSize);
        this.windows = new ArrayDeque();
        this.once = new AtomicBoolean();
        this.firstRequest = new AtomicBoolean();
        this.requested = new AtomicLong();
        this.wip = new AtomicInteger();
        this.bufferSize = bufferSize;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        long i2 = this.index;
        if (i2 == 0L && !this.cancelled) {
            this.getAndIncrement();
            UnicastProcessor w2 = UnicastProcessor.create(this.bufferSize, this);
            this.windows.offer(w2);
            this.queue.offer(w2);
            this.drain();
        }
        ++i2;
        for (Yv yv2 : this.windows) {
            yv2.onNext(t2);
        }
        long p2 = this.produced + 1L;
        if (p2 == this.size) {
            this.produced = p2 - this.skip;
            Yv w4 = this.windows.poll();
            if (w4 != null) {
                w4.onComplete();
            }
        } else {
            this.produced = p2;
        }
        this.index = i2 == this.skip ? 0L : i2;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        for (Yv yv2 : this.windows) {
            yv2.onError(t2);
        }
        this.windows.clear();
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        for (Yv yv2 : this.windows) {
            yv2.onComplete();
        }
        this.windows.clear();
        this.done = true;
        this.drain();
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        Yx<Flowable<UnicastProcessor<T>>> a2 = this.actual;
        SpscLinkedArrayQueue<UnicastProcessor<T>> q2 = this.queue;
        int missed = 1;
        do {
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                boolean empty;
                boolean d2 = this.done;
                UnicastProcessor<T> t2 = q2.poll();
                boolean bl2 = empty = t2 == null;
                if (this.checkTerminated(d2, empty, a2, q2)) {
                    return;
                }
                if (empty) break;
                a2.onNext(t2);
            }
            if (e2 == r2 && this.checkTerminated(this.done, q2.isEmpty(), a2, q2)) {
                return;
            }
            if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-e2);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }

    boolean checkTerminated(boolean d2, boolean empty, Yx<?> a2, SpscLinkedArrayQueue<?> q2) {
        if (this.cancelled) {
            q2.clear();
            return true;
        }
        if (d2) {
            Throwable e2 = this.error;
            if (e2 != null) {
                q2.clear();
                a2.onError(e2);
                return true;
            }
            if (empty) {
                a2.onComplete();
                return true;
            }
        }
        return false;
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            if (!this.firstRequest.get() && this.firstRequest.compareAndSet(false, true)) {
                long u2 = BackpressureHelper.multiplyCap(this.skip, n2 - 1L);
                long v2 = BackpressureHelper.addCap(this.size, u2);
                this.s.request(v2);
            } else {
                long u3 = BackpressureHelper.multiplyCap(this.skip, n2);
                this.s.request(u3);
            }
            this.drain();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.once.compareAndSet(false, true)) {
            this.run();
        }
    }

    @Override
    public void run() {
        if (this.decrementAndGet() == 0) {
            this.s.cancel();
        }
    }
}

