/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.flowable.FlowableTimeoutTimed$TimeoutSupport;
import io.reactivex.internal.operators.flowable.FlowableTimeoutTimed$TimeoutTask;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableTimeoutTimed$TimeoutSubscriber<T>
extends AtomicLong
implements Yy,
FlowableSubscriber<T>,
FlowableTimeoutTimed$TimeoutSupport {
    private static final long serialVersionUID = 3764492702657003550L;
    final Yx<? super T> actual;
    final long timeout;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    final SequentialDisposable task;
    final AtomicReference<Yy> upstream;
    final AtomicLong requested;

    FlowableTimeoutTimed$TimeoutSubscriber(Yx<? super T> actual, long timeout, TimeUnit unit, Scheduler$Worker worker) {
        this.actual = actual;
        this.timeout = timeout;
        this.unit = unit;
        this.worker = worker;
        this.task = new SequentialDisposable();
        this.upstream = new AtomicReference();
        this.requested = new AtomicLong();
    }

    @Override
    public void onSubscribe(Yy s2) {
        SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s2);
    }

    @Override
    public void onNext(T t2) {
        long idx = this.get();
        if (idx == Long.MAX_VALUE || !this.compareAndSet(idx, idx + 1L)) {
            return;
        }
        ((Disposable)this.task.get()).dispose();
        this.actual.onNext(t2);
        this.startTimeout(idx + 1L);
    }

    void startTimeout(long nextIndex) {
        this.task.replace(this.worker.schedule(new FlowableTimeoutTimed$TimeoutTask(nextIndex, this), this.timeout, this.unit));
    }

    @Override
    public void onError(Throwable t2) {
        if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
            this.task.dispose();
            this.actual.onError(t2);
            this.worker.dispose();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
            this.task.dispose();
            this.actual.onComplete();
            this.worker.dispose();
        }
    }

    @Override
    public void onTimeout(long idx) {
        if (this.compareAndSet(idx, Long.MAX_VALUE)) {
            SubscriptionHelper.cancel(this.upstream);
            this.actual.onError(new TimeoutException());
            this.worker.dispose();
        }
    }

    @Override
    public void request(long n2) {
        SubscriptionHelper.deferredRequest(this.upstream, this.requested, n2);
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this.upstream);
        this.worker.dispose();
    }
}

