/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableTimeout$TimeoutConsumer;
import io.reactivex.internal.operators.flowable.FlowableTimeout$TimeoutSelectorSupport;
import io.reactivex.internal.operators.flowable.FlowableTimeoutTimed$FallbackSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableTimeout$TimeoutFallbackSubscriber<T>
extends SubscriptionArbiter
implements FlowableSubscriber<T>,
FlowableTimeout$TimeoutSelectorSupport {
    private static final long serialVersionUID = 3764492702657003550L;
    final Yx<? super T> actual;
    final Function<? super T, ? extends Yw<?>> itemTimeoutIndicator;
    final SequentialDisposable task;
    final AtomicReference<Yy> upstream;
    final AtomicLong index;
    Yw<? extends T> fallback;
    long consumed;

    FlowableTimeout$TimeoutFallbackSubscriber(Yx<? super T> actual, Function<? super T, ? extends Yw<?>> itemTimeoutIndicator, Yw<? extends T> fallback) {
        this.actual = actual;
        this.itemTimeoutIndicator = itemTimeoutIndicator;
        this.task = new SequentialDisposable();
        this.upstream = new AtomicReference();
        this.fallback = fallback;
        this.index = new AtomicLong();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this.upstream, s2)) {
            this.setSubscription(s2);
        }
    }

    @Override
    public void onNext(T t2) {
        Yw<?> itemTimeoutPublisher;
        long idx = this.index.get();
        if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
            return;
        }
        Disposable d2 = (Disposable)this.task.get();
        if (d2 != null) {
            d2.dispose();
        }
        ++this.consumed;
        this.actual.onNext(t2);
        try {
            itemTimeoutPublisher = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t2), "The itemTimeoutIndicator returned a null Publisher.");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.upstream.get().cancel();
            this.index.getAndSet(Long.MAX_VALUE);
            this.actual.onError(ex2);
            return;
        }
        FlowableTimeout$TimeoutConsumer consumer = new FlowableTimeout$TimeoutConsumer(idx + 1L, this);
        if (this.task.replace(consumer)) {
            itemTimeoutPublisher.subscribe(consumer);
        }
    }

    void startFirstTimeout(Yw<?> firstTimeoutIndicator) {
        FlowableTimeout$TimeoutConsumer consumer;
        if (firstTimeoutIndicator != null && this.task.replace(consumer = new FlowableTimeout$TimeoutConsumer(0L, this))) {
            firstTimeoutIndicator.subscribe(consumer);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
            this.task.dispose();
            this.actual.onError(t2);
            this.task.dispose();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
            this.task.dispose();
            this.actual.onComplete();
            this.task.dispose();
        }
    }

    @Override
    public void onTimeout(long idx) {
        if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
            SubscriptionHelper.cancel(this.upstream);
            Yw<? super T> f2 = this.fallback;
            this.fallback = null;
            long c2 = this.consumed;
            if (c2 != 0L) {
                this.produced(c2);
            }
            f2.subscribe(new FlowableTimeoutTimed$FallbackSubscriber<T>(this.actual, this));
        }
    }

    @Override
    public void onTimeoutError(long idx, Throwable ex2) {
        if (this.index.compareAndSet(idx, Long.MAX_VALUE)) {
            SubscriptionHelper.cancel(this.upstream);
            this.actual.onError(ex2);
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        this.task.dispose();
    }
}

