/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableThrottleFirstTimed$DebounceTimedSubscriber<T>
extends AtomicLong
implements Yy,
FlowableSubscriber<T>,
Runnable {
    private static final long serialVersionUID = -9102637559663639004L;
    final Yx<? super T> actual;
    final long timeout;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    Yy s;
    final SequentialDisposable timer = new SequentialDisposable();
    volatile boolean gate;
    boolean done;

    FlowableThrottleFirstTimed$DebounceTimedSubscriber(Yx<? super T> actual, long timeout, TimeUnit unit, Scheduler$Worker worker) {
        this.actual = actual;
        this.timeout = timeout;
        this.unit = unit;
        this.worker = worker;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (!this.gate) {
            this.gate = true;
            long r2 = this.get();
            if (r2 == 0L) {
                this.done = true;
                this.cancel();
                this.actual.onError(new MissingBackpressureException("Could not deliver value due to lack of requests"));
                return;
            }
            this.actual.onNext(t2);
            BackpressureHelper.produced(this, 1L);
            Disposable d2 = (Disposable)this.timer.get();
            if (d2 != null) {
                d2.dispose();
            }
            this.timer.replace(this.worker.schedule(this, this.timeout, this.unit));
        }
    }

    @Override
    public void run() {
        this.gate = false;
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
        this.worker.dispose();
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
        this.worker.dispose();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this, n2);
        }
    }

    @Override
    public void cancel() {
        this.s.cancel();
        this.worker.dispose();
    }
}

