/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableTakeLastTimed$TakeLastTimedSubscriber<T>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -5677354903406201275L;
    final Yx<? super T> actual;
    final long count;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final SpscLinkedArrayQueue<Object> queue;
    final boolean delayError;
    Yy s;
    final AtomicLong requested = new AtomicLong();
    volatile boolean cancelled;
    volatile boolean done;
    Throwable error;

    FlowableTakeLastTimed$TakeLastTimedSubscriber(Yx<? super T> actual, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        this.actual = actual;
        this.count = count;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.queue = new SpscLinkedArrayQueue(bufferSize);
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        long now = this.scheduler.now(this.unit);
        q2.offer(now, t2);
        this.trim(now, q2);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.delayError) {
            this.trim(this.scheduler.now(this.unit), this.queue);
        }
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.trim(this.scheduler.now(this.unit), this.queue);
        this.done = true;
        this.drain();
    }

    void trim(long now, SpscLinkedArrayQueue<Object> q2) {
        long ts2;
        boolean unbounded;
        long time = this.time;
        long c2 = this.count;
        boolean bl2 = unbounded = c2 == Long.MAX_VALUE;
        while (!q2.isEmpty() && ((ts2 = ((Long)q2.peek()).longValue()) < now - time || !unbounded && (long)(q2.size() >> 1) > c2)) {
            q2.poll();
            q2.poll();
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx<Object> a2 = this.actual;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        boolean delayError = this.delayError;
        do {
            if (!this.done) continue;
            boolean empty = q2.isEmpty();
            if (this.checkTerminated(empty, a2, delayError)) {
                return;
            }
            long r2 = this.requested.get();
            long e2 = 0L;
            while (true) {
                Object ts2;
                boolean bl2 = empty = (ts2 = q2.peek()) == null;
                if (this.checkTerminated(empty, a2, delayError)) {
                    return;
                }
                if (r2 == e2) break;
                q2.poll();
                Object o2 = q2.poll();
                a2.onNext(o2);
                ++e2;
            }
            if (e2 == 0L) continue;
            BackpressureHelper.produced(this.requested, e2);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    boolean checkTerminated(boolean empty, Yx<? super T> a2, boolean delayError) {
        if (this.cancelled) {
            this.queue.clear();
            return true;
        }
        if (delayError) {
            if (empty) {
                Throwable e2 = this.error;
                if (e2 != null) {
                    a2.onError(e2);
                } else {
                    a2.onComplete();
                }
                return true;
            }
        } else {
            Throwable e3 = this.error;
            if (e3 != null) {
                this.queue.clear();
                a2.onError(e3);
                return true;
            }
            if (empty) {
                a2.onComplete();
                return true;
            }
        }
        return false;
    }
}

