/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableTakeLast$TakeLastSubscriber<T>
extends ArrayDeque<T>
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = 7240042530241604978L;
    final Yx<? super T> actual;
    final int count;
    Yy s;
    volatile boolean done;
    volatile boolean cancelled;
    final AtomicLong requested = new AtomicLong();
    final AtomicInteger wip = new AtomicInteger();

    FlowableTakeLast$TakeLastSubscriber(Yx<? super T> actual, int count) {
        this.actual = actual;
        this.count = count;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.count == this.size()) {
            this.poll();
        }
        this.offer(t2);
    }

    @Override
    public void onError(Throwable t2) {
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.s.cancel();
    }

    void drain() {
        if (this.wip.getAndIncrement() == 0) {
            Yx a2 = this.actual;
            long r2 = this.requested.get();
            do {
                long e2;
                if (this.cancelled) {
                    return;
                }
                if (!this.done) continue;
                for (e2 = 0L; e2 != r2; ++e2) {
                    if (this.cancelled) {
                        return;
                    }
                    Object v2 = this.poll();
                    if (v2 == null) {
                        a2.onComplete();
                        return;
                    }
                    a2.onNext(v2);
                }
                if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
                r2 = this.requested.addAndGet(-e2);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

