/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicBoolean;

final class FlowableTake$TakeSubscriber<T>
extends AtomicBoolean
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -5636543848937116287L;
    boolean done;
    Yy subscription;
    final Yx<? super T> actual;
    final long limit;
    long remaining;

    FlowableTake$TakeSubscriber(Yx<? super T> actual, long limit) {
        this.actual = actual;
        this.limit = limit;
        this.remaining = limit;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.subscription, s2)) {
            this.subscription = s2;
            if (this.limit == 0L) {
                s2.cancel();
                this.done = true;
                EmptySubscription.complete(this.actual);
            } else {
                this.actual.onSubscribe(this);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.done && this.remaining-- > 0L) {
            boolean stop = this.remaining == 0L;
            this.actual.onNext(t2);
            if (stop) {
                this.subscription.cancel();
                this.onComplete();
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.done) {
            this.done = true;
            this.subscription.cancel();
            this.actual.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.actual.onComplete();
        }
    }

    @Override
    public void request(long n2) {
        if (!SubscriptionHelper.validate(n2)) {
            return;
        }
        if (!this.get() && this.compareAndSet(false, true) && n2 >= this.limit) {
            this.subscription.request(Long.MAX_VALUE);
            return;
        }
        this.subscription.request(n2);
    }

    @Override
    public void cancel() {
        this.subscription.cancel();
    }
}

