/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableSequenceEqual$EqualCoordinatorHelper;
import io.reactivex.internal.operators.flowable.FlowableSequenceEqual$EqualSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

final class FlowableSequenceEqualSingle$EqualCoordinator<T>
extends AtomicInteger
implements Disposable,
FlowableSequenceEqual$EqualCoordinatorHelper {
    private static final long serialVersionUID = -6178010334400373240L;
    final SingleObserver<? super Boolean> actual;
    final BiPredicate<? super T, ? super T> comparer;
    final FlowableSequenceEqual$EqualSubscriber<T> first;
    final FlowableSequenceEqual$EqualSubscriber<T> second;
    final AtomicThrowable error;
    T v1;
    T v2;

    FlowableSequenceEqualSingle$EqualCoordinator(SingleObserver<? super Boolean> actual, int prefetch, BiPredicate<? super T, ? super T> comparer) {
        this.actual = actual;
        this.comparer = comparer;
        this.first = new FlowableSequenceEqual$EqualSubscriber(this, prefetch);
        this.second = new FlowableSequenceEqual$EqualSubscriber(this, prefetch);
        this.error = new AtomicThrowable();
    }

    void subscribe(Yw<? extends T> source1, Yw<? extends T> source2) {
        source1.subscribe(this.first);
        source2.subscribe(this.second);
    }

    @Override
    public void dispose() {
        this.first.cancel();
        this.second.cancel();
        if (this.getAndIncrement() == 0) {
            this.first.clear();
            this.second.clear();
        }
    }

    @Override
    public boolean isDisposed() {
        return SubscriptionHelper.isCancelled((Yy)this.first.get());
    }

    void cancelAndClear() {
        this.first.cancel();
        this.first.clear();
        this.second.cancel();
        this.second.clear();
    }

    @Override
    public void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        block6: do {
            Throwable ex2;
            SimpleQueue q1 = this.first.queue;
            SimpleQueue q2 = this.second.queue;
            if (q1 != null && q2 != null) {
                while (true) {
                    boolean c2;
                    boolean e2;
                    if (this.isDisposed()) {
                        this.first.clear();
                        this.second.clear();
                        return;
                    }
                    ex2 = (Throwable)this.error.get();
                    if (ex2 != null) {
                        this.cancelAndClear();
                        this.actual.onError(this.error.terminate());
                        return;
                    }
                    boolean d1 = this.first.done;
                    T a2 = this.v1;
                    if (a2 == null) {
                        try {
                            a2 = q1.poll();
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancelAndClear();
                            this.error.addThrowable(exc);
                            this.actual.onError(this.error.terminate());
                            return;
                        }
                        this.v1 = a2;
                    }
                    boolean e1 = a2 == null;
                    boolean d2 = this.second.done;
                    T b2 = this.v2;
                    if (b2 == null) {
                        try {
                            b2 = q2.poll();
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancelAndClear();
                            this.error.addThrowable(exc);
                            this.actual.onError(this.error.terminate());
                            return;
                        }
                        this.v2 = b2;
                    }
                    boolean bl2 = e2 = b2 == null;
                    if (d1 && d2 && e1 && e2) {
                        this.actual.onSuccess((Boolean)true);
                        return;
                    }
                    if (d1 && d2 && e1 != e2) {
                        this.cancelAndClear();
                        this.actual.onSuccess((Boolean)false);
                        return;
                    }
                    if (e1 || e2) continue block6;
                    try {
                        c2 = this.comparer.test(a2, b2);
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        this.cancelAndClear();
                        this.error.addThrowable(exc);
                        this.actual.onError(this.error.terminate());
                        return;
                    }
                    if (!c2) {
                        this.cancelAndClear();
                        this.actual.onSuccess((Boolean)false);
                        return;
                    }
                    this.v1 = null;
                    this.v2 = null;
                    this.first.request();
                    this.second.request();
                }
            }
            if (this.isDisposed()) {
                this.first.clear();
                this.second.clear();
                return;
            }
            ex2 = (Throwable)this.error.get();
            if (ex2 == null) continue;
            this.cancelAndClear();
            this.actual.onError(this.error.terminate());
            return;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    @Override
    public void innerError(Throwable t2) {
        if (this.error.addThrowable(t2)) {
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }
}

