/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableScanSeed$ScanSeedSubscriber<T, R>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -1776795561228106469L;
    final Yx<? super R> actual;
    final BiFunction<R, ? super T, R> accumulator;
    final SimplePlainQueue<R> queue;
    final AtomicLong requested;
    final int prefetch;
    final int limit;
    volatile boolean cancelled;
    volatile boolean done;
    Throwable error;
    Yy s;
    R value;
    int consumed;

    FlowableScanSeed$ScanSeedSubscriber(Yx<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value, int prefetch) {
        this.actual = actual;
        this.accumulator = accumulator;
        this.value = value;
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
        this.queue = new SpscArrayQueue<R>(prefetch);
        this.queue.offer(value);
        this.requested = new AtomicLong();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(this.prefetch - 1);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        R v2 = this.value;
        try {
            v2 = ObjectHelper.requireNonNull(this.accumulator.apply(v2, t2), "The accumulator returned a null value");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.s.cancel();
            this.onError(ex2);
            return;
        }
        this.value = v2;
        this.queue.offer(v2);
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.s.cancel();
        if (this.getAndIncrement() == 0) {
            this.queue.clear();
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx<R> a2 = this.actual;
        SimplePlainQueue<R> q2 = this.queue;
        int lim = this.limit;
        int c2 = this.consumed;
        do {
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                boolean empty;
                Throwable ex2;
                if (this.cancelled) {
                    q2.clear();
                    return;
                }
                boolean d2 = this.done;
                if (d2 && (ex2 = this.error) != null) {
                    q2.clear();
                    a2.onError(ex2);
                    return;
                }
                R v2 = q2.poll();
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    a2.onComplete();
                    return;
                }
                if (empty) break;
                a2.onNext(v2);
                if (++c2 != lim) continue;
                c2 = 0;
                this.s.request(lim);
            }
            if (e2 == r2 && this.done) {
                Throwable ex3 = this.error;
                if (ex3 != null) {
                    q2.clear();
                    a2.onError(ex3);
                    return;
                }
                if (q2.isEmpty()) {
                    a2.onComplete();
                    return;
                }
            }
            if (e2 != 0L) {
                BackpressureHelper.produced(this.requested, e2);
            }
            this.consumed = c2;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }
}

