/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

abstract class FlowableSampleTimed$SampleTimedSubscriber<T>
extends AtomicReference<T>
implements Yy,
FlowableSubscriber<T>,
Runnable {
    private static final long serialVersionUID = -3517602651313910099L;
    final Yx<? super T> actual;
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;
    final AtomicLong requested = new AtomicLong();
    final SequentialDisposable timer = new SequentialDisposable();
    Yy s;

    FlowableSampleTimed$SampleTimedSubscriber(Yx<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
        this.actual = actual;
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            this.timer.replace(this.scheduler.schedulePeriodicallyDirect(this, this.period, this.period, this.unit));
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        this.lazySet(t2);
    }

    @Override
    public void onError(Throwable t2) {
        this.cancelTimer();
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        this.cancelTimer();
        this.complete();
    }

    void cancelTimer() {
        DisposableHelper.dispose(this.timer);
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
        }
    }

    @Override
    public void cancel() {
        this.cancelTimer();
        this.s.cancel();
    }

    void emit() {
        Object value = this.getAndSet(null);
        if (value != null) {
            long r2 = this.requested.get();
            if (r2 != 0L) {
                this.actual.onNext(value);
                BackpressureHelper.produced(this.requested, 1L);
            } else {
                this.cancel();
                this.actual.onError(new MissingBackpressureException("Couldn't emit value due to lack of requests!"));
            }
        }
    }

    abstract void complete();
}

