/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;

final class FlowableRetryPredicate$RetrySubscriber<T>
extends AtomicInteger
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -7098360935104053232L;
    final Yx<? super T> actual;
    final SubscriptionArbiter sa;
    final Yw<? extends T> source;
    final Predicate<? super Throwable> predicate;
    long remaining;
    long produced;

    FlowableRetryPredicate$RetrySubscriber(Yx<? super T> actual, long count, Predicate<? super Throwable> predicate, SubscriptionArbiter sa2, Yw<? extends T> source) {
        this.actual = actual;
        this.sa = sa2;
        this.source = source;
        this.predicate = predicate;
        this.remaining = count;
    }

    @Override
    public void onSubscribe(Yy s2) {
        this.sa.setSubscription(s2);
    }

    @Override
    public void onNext(T t2) {
        ++this.produced;
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        long r2 = this.remaining;
        if (r2 != Long.MAX_VALUE) {
            this.remaining = r2 - 1L;
        }
        if (r2 == 0L) {
            this.actual.onError(t2);
        } else {
            boolean b2;
            try {
                b2 = this.predicate.test(t2);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.actual.onError(new CompositeException(t2, e2));
                return;
            }
            if (!b2) {
                this.actual.onError(t2);
                return;
            }
            this.subscribeNext();
        }
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }

    void subscribeNext() {
        block3: {
            if (this.getAndIncrement() != 0) break block3;
            int missed = 1;
            do {
                if (this.sa.isCancelled()) {
                    return;
                }
                long p2 = this.produced;
                if (p2 != 0L) {
                    this.produced = 0L;
                    this.sa.produced(p2);
                }
                this.source.subscribe(this);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

