/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.internal.operators.flowable.FlowableReplay$ConnectableFlowableReplay;
import io.reactivex.internal.operators.flowable.FlowableReplay$DefaultUnboundedFactory;
import io.reactivex.internal.operators.flowable.FlowableReplay$MultiCastPublisher;
import io.reactivex.internal.operators.flowable.FlowableReplay$ReplayBuffer;
import io.reactivex.internal.operators.flowable.FlowableReplay$ReplayBufferTask;
import io.reactivex.internal.operators.flowable.FlowableReplay$ReplayPublisher;
import io.reactivex.internal.operators.flowable.FlowableReplay$ReplaySubscriber;
import io.reactivex.internal.operators.flowable.FlowableReplay$ScheduledReplayBufferTask;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableReplay<T>
extends ConnectableFlowable<T>
implements Disposable,
HasUpstreamPublisher<T> {
    final Flowable<T> source;
    final AtomicReference<FlowableReplay$ReplaySubscriber<T>> current;
    final Callable<? extends FlowableReplay$ReplayBuffer<T>> bufferFactory;
    final Yw<T> onSubscribe;
    static final Callable DEFAULT_UNBOUNDED_FACTORY = new FlowableReplay$DefaultUnboundedFactory();

    public static <U, R> Flowable<R> multicastSelector(Callable<? extends ConnectableFlowable<U>> connectableFactory, Function<? super Flowable<U>, ? extends Yw<R>> selector) {
        return Flowable.unsafeCreate(new FlowableReplay$MultiCastPublisher(connectableFactory, selector));
    }

    public static <T> ConnectableFlowable<T> observeOn(ConnectableFlowable<T> co2, Scheduler scheduler) {
        Flowable observable = co2.observeOn(scheduler);
        return RxJavaPlugins.onAssembly(new FlowableReplay$ConnectableFlowableReplay<T>(co2, observable));
    }

    public static <T> ConnectableFlowable<T> createFrom(Flowable<? extends T> source) {
        return FlowableReplay.create(source, DEFAULT_UNBOUNDED_FACTORY);
    }

    public static <T> ConnectableFlowable<T> create(Flowable<T> source, int bufferSize) {
        if (bufferSize == Integer.MAX_VALUE) {
            return FlowableReplay.createFrom(source);
        }
        return FlowableReplay.create(source, new FlowableReplay$ReplayBufferTask(bufferSize));
    }

    public static <T> ConnectableFlowable<T> create(Flowable<T> source, long maxAge, TimeUnit unit, Scheduler scheduler) {
        return FlowableReplay.create(source, maxAge, unit, scheduler, Integer.MAX_VALUE);
    }

    public static <T> ConnectableFlowable<T> create(Flowable<T> source, long maxAge, TimeUnit unit, Scheduler scheduler, int bufferSize) {
        return FlowableReplay.create(source, new FlowableReplay$ScheduledReplayBufferTask(bufferSize, maxAge, unit, scheduler));
    }

    static <T> ConnectableFlowable<T> create(Flowable<T> source, Callable<? extends FlowableReplay$ReplayBuffer<T>> bufferFactory) {
        AtomicReference curr = new AtomicReference();
        FlowableReplay$ReplayPublisher onSubscribe = new FlowableReplay$ReplayPublisher(curr, bufferFactory);
        return RxJavaPlugins.onAssembly(new FlowableReplay(onSubscribe, source, curr, bufferFactory));
    }

    private FlowableReplay(Yw<T> onSubscribe, Flowable<T> source, AtomicReference<FlowableReplay$ReplaySubscriber<T>> current, Callable<? extends FlowableReplay$ReplayBuffer<T>> bufferFactory) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public Yw<T> source() {
        return this.source;
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        this.onSubscribe.subscribe(s2);
    }

    @Override
    public void dispose() {
        this.current.lazySet(null);
    }

    @Override
    public boolean isDisposed() {
        Disposable d2 = this.current.get();
        return d2 == null || d2.isDisposed();
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        FlowableReplay$ReplaySubscriber<T> ps2;
        while ((ps2 = this.current.get()) == null || ps2.isDisposed()) {
            FlowableReplay$ReplayBuffer<T> buf;
            try {
                buf = this.bufferFactory.call();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
            FlowableReplay$ReplaySubscriber<T> u2 = new FlowableReplay$ReplaySubscriber<T>(buf);
            if (!this.current.compareAndSet(ps2, u2)) continue;
            ps2 = u2;
            break;
        }
        boolean doConnect = !ps2.shouldConnect.get() && ps2.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps2);
        }
        catch (Throwable ex3) {
            if (doConnect) {
                ps2.shouldConnect.compareAndSet(true, false);
            }
            Exceptions.throwIfFatal(ex3);
            throw ExceptionHelper.wrapOrThrow(ex3);
        }
        if (doConnect) {
            this.source.subscribe(ps2);
        }
    }
}

