/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.operators.flowable.FlowableReplay$InnerSubscription;
import io.reactivex.internal.operators.flowable.FlowableReplay$ReplayBuffer;
import io.reactivex.internal.util.NotificationLite;
import java.util.ArrayList;

final class FlowableReplay$UnboundedReplayBuffer<T>
extends ArrayList<Object>
implements FlowableReplay$ReplayBuffer<T> {
    private static final long serialVersionUID = 7063189396499112664L;
    volatile int size;

    FlowableReplay$UnboundedReplayBuffer(int capacityHint) {
        super(capacityHint);
    }

    @Override
    public void next(T value) {
        this.add(NotificationLite.next(value));
        ++this.size;
    }

    @Override
    public void error(Throwable e2) {
        this.add(NotificationLite.error(e2));
        ++this.size;
    }

    @Override
    public void complete() {
        this.add(NotificationLite.complete());
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replay(FlowableReplay$InnerSubscription<T> output) {
        FlowableReplay$InnerSubscription<T> flowableReplay$InnerSubscription = output;
        synchronized (flowableReplay$InnerSubscription) {
            if (output.emitting) {
                output.missed = true;
                return;
            }
            output.emitting = true;
        }
        Yx child = output.child;
        while (!output.isDisposed()) {
            long r2;
            int sourceIndex = this.size;
            Integer destinationIndexObject = (Integer)output.index();
            int destinationIndex = destinationIndexObject != null ? destinationIndexObject : 0;
            long r0 = r2 = output.get();
            long e2 = 0L;
            while (r2 != 0L && destinationIndex < sourceIndex) {
                Object o2 = this.get(destinationIndex);
                try {
                    if (NotificationLite.accept(o2, child)) {
                        return;
                    }
                }
                catch (Throwable err) {
                    Exceptions.throwIfFatal(err);
                    output.dispose();
                    if (!NotificationLite.isError(o2) && !NotificationLite.isComplete(o2)) {
                        child.onError(err);
                    }
                    return;
                }
                if (output.isDisposed()) {
                    return;
                }
                ++destinationIndex;
                --r2;
                ++e2;
            }
            if (e2 != 0L) {
                output.index = destinationIndex;
                if (r0 != Long.MAX_VALUE) {
                    output.produced(e2);
                }
            }
            FlowableReplay$InnerSubscription<T> flowableReplay$InnerSubscription2 = output;
            synchronized (flowableReplay$InnerSubscription2) {
                if (!output.missed) {
                    output.emitting = false;
                    return;
                }
                output.missed = false;
            }
        }
        return;
    }
}

