/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableReplay$MultiCastPublisher$DisposableConsumer;
import io.reactivex.internal.subscribers.SubscriberResourceWrapper;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.concurrent.Callable;

final class FlowableReplay$MultiCastPublisher<R, U>
implements Yw<R> {
    private final Callable<? extends ConnectableFlowable<U>> connectableFactory;
    private final Function<? super Flowable<U>, ? extends Yw<R>> selector;

    FlowableReplay$MultiCastPublisher(Callable<? extends ConnectableFlowable<U>> connectableFactory, Function<? super Flowable<U>, ? extends Yw<R>> selector) {
        this.connectableFactory = connectableFactory;
        this.selector = selector;
    }

    @Override
    public void subscribe(Yx<? super R> child) {
        Yw<R> observable;
        ConnectableFlowable<U> co2;
        try {
            co2 = ObjectHelper.requireNonNull(this.connectableFactory.call(), "The connectableFactory returned null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptySubscription.error(e2, child);
            return;
        }
        try {
            observable = ObjectHelper.requireNonNull(this.selector.apply(co2), "The selector returned a null Publisher");
        }
        catch (Throwable e3) {
            Exceptions.throwIfFatal(e3);
            EmptySubscription.error(e3, child);
            return;
        }
        SubscriberResourceWrapper<? super R> srw = new SubscriberResourceWrapper<R>(child);
        observable.subscribe(srw);
        co2.connect(new FlowableReplay$MultiCastPublisher$DisposableConsumer(this, srw));
    }
}

