/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.operators.flowable.FlowableReplay$InnerSubscription;
import io.reactivex.internal.operators.flowable.FlowableReplay$Node;
import io.reactivex.internal.operators.flowable.FlowableReplay$ReplayBuffer;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.NotificationLite;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

class FlowableReplay$BoundedReplayBuffer<T>
extends AtomicReference<FlowableReplay$Node>
implements FlowableReplay$ReplayBuffer<T> {
    private static final long serialVersionUID = 2346567790059478686L;
    FlowableReplay$Node tail;
    int size;
    long index;

    FlowableReplay$BoundedReplayBuffer() {
        FlowableReplay$Node n2;
        this.tail = n2 = new FlowableReplay$Node(null, 0L);
        this.set(n2);
    }

    final void addLast(FlowableReplay$Node n2) {
        this.tail.set(n2);
        this.tail = n2;
        ++this.size;
    }

    final void removeFirst() {
        FlowableReplay$Node head = (FlowableReplay$Node)this.get();
        FlowableReplay$Node next = (FlowableReplay$Node)head.get();
        if (next == null) {
            throw new IllegalStateException("Empty list!");
        }
        --this.size;
        this.setFirst(next);
    }

    final void removeSome(int n2) {
        FlowableReplay$Node head = (FlowableReplay$Node)this.get();
        while (n2 > 0) {
            head = (FlowableReplay$Node)head.get();
            --n2;
            --this.size;
        }
        this.setFirst(head);
    }

    final void setFirst(FlowableReplay$Node n2) {
        this.set(n2);
    }

    @Override
    public final void next(T value) {
        Object o2 = this.enterTransform(NotificationLite.next(value));
        FlowableReplay$Node n2 = new FlowableReplay$Node(o2, ++this.index);
        this.addLast(n2);
        this.truncate();
    }

    @Override
    public final void error(Throwable e2) {
        Object o2 = this.enterTransform(NotificationLite.error(e2));
        FlowableReplay$Node n2 = new FlowableReplay$Node(o2, ++this.index);
        this.addLast(n2);
        this.truncateFinal();
    }

    @Override
    public final void complete() {
        Object o2 = this.enterTransform(NotificationLite.complete());
        FlowableReplay$Node n2 = new FlowableReplay$Node(o2, ++this.index);
        this.addLast(n2);
        this.truncateFinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void replay(FlowableReplay$InnerSubscription<T> output) {
        FlowableReplay$InnerSubscription<T> flowableReplay$InnerSubscription = output;
        synchronized (flowableReplay$InnerSubscription) {
            if (output.emitting) {
                output.missed = true;
                return;
            }
            output.emitting = true;
        }
        while (!output.isDisposed()) {
            FlowableReplay$Node v2;
            long r2 = output.get();
            boolean unbounded = r2 == Long.MAX_VALUE;
            long e2 = 0L;
            FlowableReplay$Node node = (FlowableReplay$Node)output.index();
            if (node == null) {
                node = this.getHead();
                output.index = node;
                BackpressureHelper.add(output.totalRequested, node.index);
            }
            while (r2 != 0L && (v2 = (FlowableReplay$Node)node.get()) != null) {
                Object o2 = this.leaveTransform(v2.value);
                try {
                    if (NotificationLite.accept(o2, output.child)) {
                        output.index = null;
                        return;
                    }
                }
                catch (Throwable err) {
                    Exceptions.throwIfFatal(err);
                    output.index = null;
                    output.dispose();
                    if (!NotificationLite.isError(o2) && !NotificationLite.isComplete(o2)) {
                        output.child.onError(err);
                    }
                    return;
                }
                ++e2;
                --r2;
                node = v2;
                if (!output.isDisposed()) continue;
                return;
            }
            if (e2 != 0L) {
                output.index = node;
                if (!unbounded) {
                    output.produced(e2);
                }
            }
            FlowableReplay$InnerSubscription<T> flowableReplay$InnerSubscription2 = output;
            synchronized (flowableReplay$InnerSubscription2) {
                if (!output.missed) {
                    output.emitting = false;
                    return;
                }
                output.missed = false;
            }
        }
        return;
    }

    Object enterTransform(Object value) {
        return value;
    }

    Object leaveTransform(Object value) {
        return value;
    }

    void truncate() {
    }

    void truncateFinal() {
    }

    final void collect(Collection<? super T> output) {
        Object o2;
        Object v2;
        FlowableReplay$Node next;
        FlowableReplay$Node n2 = this.getHead();
        while ((next = (FlowableReplay$Node)n2.get()) != null && !NotificationLite.isComplete(v2 = this.leaveTransform(o2 = next.value)) && !NotificationLite.isError(v2)) {
            output.add(NotificationLite.getValue(v2));
            n2 = next;
        }
    }

    boolean hasError() {
        return this.tail.value != null && NotificationLite.isError(this.leaveTransform(this.tail.value));
    }

    boolean hasCompleted() {
        return this.tail.value != null && NotificationLite.isComplete(this.leaveTransform(this.tail.value));
    }

    FlowableReplay$Node getHead() {
        return (FlowableReplay$Node)this.get();
    }
}

