/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class FlowableReduceMaybe$ReduceSubscriber<T>
implements FlowableSubscriber<T>,
Disposable {
    final MaybeObserver<? super T> actual;
    final BiFunction<T, T, T> reducer;
    T value;
    Yy s;
    boolean done;

    FlowableReduceMaybe$ReduceSubscriber(MaybeObserver<? super T> actual, BiFunction<T, T, T> reducer) {
        this.actual = actual;
        this.reducer = reducer;
    }

    @Override
    public void dispose() {
        this.s.cancel();
        this.done = true;
    }

    @Override
    public boolean isDisposed() {
        return this.done;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        T v2 = this.value;
        if (v2 == null) {
            this.value = t2;
        } else {
            try {
                this.value = ObjectHelper.requireNonNull(this.reducer.apply(v2, t2), "The reducer returned a null value");
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.s.cancel();
                this.onError(ex2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        T v2 = this.value;
        if (v2 != null) {
            this.actual.onSuccess(v2);
        } else {
            this.actual.onComplete();
        }
    }
}

