/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowablePublishMulticast$MulticastSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class FlowablePublishMulticast$MulticastProcessor<T>
extends Flowable<T>
implements FlowableSubscriber<T>,
Disposable {
    static final FlowablePublishMulticast$MulticastSubscription[] EMPTY = new FlowablePublishMulticast$MulticastSubscription[0];
    static final FlowablePublishMulticast$MulticastSubscription[] TERMINATED = new FlowablePublishMulticast$MulticastSubscription[0];
    final AtomicInteger wip;
    final AtomicReference<FlowablePublishMulticast$MulticastSubscription<T>[]> subscribers;
    final int prefetch;
    final int limit;
    final boolean delayError;
    final AtomicReference<Yy> s;
    volatile SimpleQueue<T> queue;
    int sourceMode;
    volatile boolean done;
    Throwable error;
    int consumed;

    FlowablePublishMulticast$MulticastProcessor(int prefetch, boolean delayError) {
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
        this.delayError = delayError;
        this.wip = new AtomicInteger();
        this.s = new AtomicReference();
        this.subscribers = new AtomicReference<FlowablePublishMulticast$MulticastSubscription[]>(EMPTY);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.setOnce(this.s, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(3);
                if (m2 == 1) {
                    this.sourceMode = m2;
                    this.queue = qs2;
                    this.done = true;
                    this.drain();
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = m2;
                    this.queue = qs2;
                    QueueDrainHelper.request(s2, this.prefetch);
                    return;
                }
            }
            this.queue = QueueDrainHelper.createQueue(this.prefetch);
            QueueDrainHelper.request(s2, this.prefetch);
        }
    }

    @Override
    public void dispose() {
        SimpleQueue<T> q2;
        SubscriptionHelper.cancel(this.s);
        if (this.wip.getAndIncrement() == 0 && (q2 = this.queue) != null) {
            q2.clear();
        }
    }

    @Override
    public boolean isDisposed() {
        return SubscriptionHelper.isCancelled(this.s.get());
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.sourceMode == 0 && !this.queue.offer(t2)) {
            this.s.get().cancel();
            this.onError(new MissingBackpressureException());
            return;
        }
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        if (!this.done) {
            this.done = true;
            this.drain();
        }
    }

    boolean add(FlowablePublishMulticast$MulticastSubscription<T> s2) {
        FlowablePublishMulticast$MulticastSubscription[] next;
        FlowablePublishMulticast$MulticastSubscription<T>[] current;
        do {
            if ((current = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n2 = current.length;
            next = new FlowablePublishMulticast$MulticastSubscription[n2 + 1];
            System.arraycopy(current, 0, next, 0, n2);
            next[n2] = s2;
        } while (!this.subscribers.compareAndSet(current, next));
        return true;
    }

    void remove(FlowablePublishMulticast$MulticastSubscription<T> s2) {
        FlowablePublishMulticast$MulticastSubscription[] next;
        FlowablePublishMulticast$MulticastSubscription<T>[] current;
        do {
            if ((current = this.subscribers.get()) == TERMINATED || current == EMPTY) {
                return;
            }
            int n2 = current.length;
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (current[i2] != s2) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                next = EMPTY;
                continue;
            }
            next = new FlowablePublishMulticast$MulticastSubscription[n2 - 1];
            System.arraycopy(current, 0, next, 0, j2);
            System.arraycopy(current, j2 + 1, next, j2, n2 - j2 - 1);
        } while (!this.subscribers.compareAndSet(current, next));
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        FlowablePublishMulticast$MulticastSubscription<T> ms2 = new FlowablePublishMulticast$MulticastSubscription<T>(s2, this);
        s2.onSubscribe(ms2);
        if (this.add(ms2)) {
            if (ms2.isCancelled()) {
                this.remove(ms2);
                return;
            }
            this.drain();
        } else {
            Throwable ex2 = this.error;
            if (ex2 != null) {
                s2.onError(ex2);
            } else {
                s2.onComplete();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        SimpleQueue<T> q2 = this.queue;
        int upstreamConsumed = this.consumed;
        int localLimit = this.limit;
        boolean canRequest = this.sourceMode != 1;
        while (true) {
            FlowablePublishMulticast$MulticastSubscription<T>[] array = this.subscribers.get();
            int n2 = array.length;
            if (q2 != null && n2 != 0) {
                long e2;
                long r2 = Long.MAX_VALUE;
                for (FlowablePublishMulticast$MulticastSubscription<T> ms2 : array) {
                    long u2 = ms2.get();
                    if (u2 == Long.MIN_VALUE || r2 <= u2) continue;
                    r2 = u2;
                }
                for (e2 = 0L; e2 != r2; ++e2) {
                    void v2;
                    boolean empty;
                    Throwable ex2;
                    if (this.isDisposed()) {
                        q2.clear();
                        return;
                    }
                    boolean d2 = this.done;
                    if (d2 && !this.delayError && (ex2 = this.error) != null) {
                        this.errorAll(ex2);
                        return;
                    }
                    try {
                        T v22 = q2.poll();
                    }
                    catch (Throwable ex3) {
                        Exceptions.throwIfFatal(ex3);
                        SubscriptionHelper.cancel(this.s);
                        this.errorAll(ex3);
                        return;
                    }
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        Throwable throwable = this.error;
                        if (throwable != null) {
                            this.errorAll(throwable);
                        } else {
                            this.completeAll();
                        }
                        return;
                    }
                    if (empty) break;
                    for (FlowablePublishMulticast$MulticastSubscription<T> ms3 : array) {
                        if (ms3.get() == Long.MIN_VALUE) continue;
                        ms3.actual.onNext(v2);
                    }
                    if (!canRequest || ++upstreamConsumed != localLimit) continue;
                    upstreamConsumed = 0;
                    this.s.get().request(localLimit);
                }
                if (e2 == r2) {
                    Throwable ex2;
                    if (this.isDisposed()) {
                        q2.clear();
                        return;
                    }
                    boolean d2 = this.done;
                    if (d2 && !this.delayError && (ex2 = this.error) != null) {
                        this.errorAll(ex2);
                        return;
                    }
                    if (d2 && q2.isEmpty()) {
                        ex2 = this.error;
                        if (ex2 != null) {
                            this.errorAll(ex2);
                        } else {
                            this.completeAll();
                        }
                        return;
                    }
                }
                for (FlowablePublishMulticast$MulticastSubscription<T> flowablePublishMulticast$MulticastSubscription : array) {
                    BackpressureHelper.produced(flowablePublishMulticast$MulticastSubscription, e2);
                }
            }
            this.consumed = upstreamConsumed;
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            if (q2 != null) continue;
            q2 = this.queue;
        }
    }

    void errorAll(Throwable ex2) {
        for (FlowablePublishMulticast$MulticastSubscription ms2 : this.subscribers.getAndSet(TERMINATED)) {
            if (ms2.get() == Long.MIN_VALUE) continue;
            ms2.actual.onError(ex2);
        }
    }

    void completeAll() {
        for (FlowablePublishMulticast$MulticastSubscription ms2 : this.subscribers.getAndSet(TERMINATED)) {
            if (ms2.get() == Long.MIN_VALUE) continue;
            ms2.actual.onComplete();
        }
    }
}

