/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.internal.operators.flowable.FlowablePublish$FlowablePublisher;
import io.reactivex.internal.operators.flowable.FlowablePublish$PublishSubscriber;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowablePublish<T>
extends ConnectableFlowable<T>
implements HasUpstreamPublisher<T> {
    static final long CANCELLED = Long.MIN_VALUE;
    final Flowable<T> source;
    final AtomicReference<FlowablePublish$PublishSubscriber<T>> current;
    final int bufferSize;
    final Yw<T> onSubscribe;

    public static <T> ConnectableFlowable<T> create(Flowable<T> source, int bufferSize) {
        AtomicReference curr = new AtomicReference();
        FlowablePublish$FlowablePublisher onSubscribe = new FlowablePublish$FlowablePublisher(curr, bufferSize);
        return RxJavaPlugins.onAssembly(new FlowablePublish(onSubscribe, source, curr, bufferSize));
    }

    private FlowablePublish(Yw<T> onSubscribe, Flowable<T> source, AtomicReference<FlowablePublish$PublishSubscriber<T>> current, int bufferSize) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferSize = bufferSize;
    }

    @Override
    public Yw<T> source() {
        return this.source;
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        this.onSubscribe.subscribe(s2);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        FlowablePublish$PublishSubscriber<T> ps2;
        while ((ps2 = this.current.get()) == null || ps2.isDisposed()) {
            FlowablePublish$PublishSubscriber<T> u2 = new FlowablePublish$PublishSubscriber<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(ps2, u2)) continue;
            ps2 = u2;
            break;
        }
        boolean doConnect = !ps2.shouldConnect.get() && ps2.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            throw ExceptionHelper.wrapOrThrow(ex2);
        }
        if (doConnect) {
            this.source.subscribe(ps2);
        }
    }
}

