/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableOnBackpressureDrop$BackpressureDropSubscriber<T>
extends AtomicLong
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -6246093802440953054L;
    final Yx<? super T> actual;
    final Consumer<? super T> onDrop;
    Yy s;
    boolean done;

    FlowableOnBackpressureDrop$BackpressureDropSubscriber(Yx<? super T> actual, Consumer<? super T> onDrop) {
        this.actual = actual;
        this.onDrop = onDrop;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        long r2 = this.get();
        if (r2 != 0L) {
            this.actual.onNext(t2);
            BackpressureHelper.produced(this, 1L);
        } else {
            try {
                this.onDrop.accept(t2);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.cancel();
                this.onError(e2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this, n2);
        }
    }

    @Override
    public void cancel() {
        this.s.cancel();
    }
}

