/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.BackpressureOverflowStrategy;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Action;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableOnBackpressureBufferStrategy$OnBackpressureBufferStrategySubscriber<T>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = 3240706908776709697L;
    final Yx<? super T> actual;
    final Action onOverflow;
    final BackpressureOverflowStrategy strategy;
    final long bufferSize;
    final AtomicLong requested;
    final Deque<T> deque;
    Yy s;
    volatile boolean cancelled;
    volatile boolean done;
    Throwable error;

    FlowableOnBackpressureBufferStrategy$OnBackpressureBufferStrategySubscriber(Yx<? super T> actual, Action onOverflow, BackpressureOverflowStrategy strategy, long bufferSize) {
        this.actual = actual;
        this.onOverflow = onOverflow;
        this.strategy = strategy;
        this.bufferSize = bufferSize;
        this.requested = new AtomicLong();
        this.deque = new ArrayDeque<T>();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t2) {
        Deque<T> dq2;
        if (this.done) {
            return;
        }
        boolean callOnOverflow = false;
        boolean callError = false;
        Deque<T> deque = dq2 = this.deque;
        synchronized (deque) {
            if ((long)dq2.size() == this.bufferSize) {
                switch (this.strategy) {
                    case DROP_LATEST: {
                        dq2.pollLast();
                        dq2.offer(t2);
                        callOnOverflow = true;
                        break;
                    }
                    case DROP_OLDEST: {
                        dq2.poll();
                        dq2.offer(t2);
                        callOnOverflow = true;
                        break;
                    }
                    default: {
                        callError = true;
                        break;
                    }
                }
            } else {
                dq2.offer(t2);
            }
        }
        if (callOnOverflow) {
            if (this.onOverflow != null) {
                try {
                    this.onOverflow.run();
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.s.cancel();
                    this.onError(ex2);
                }
            }
        } else if (callError) {
            this.s.cancel();
            this.onError(new MissingBackpressureException());
        } else {
            this.drain();
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.error = t2;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.s.cancel();
        if (this.getAndIncrement() == 0) {
            this.clear(this.deque);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(Deque<T> dq2) {
        Deque<T> deque = dq2;
        synchronized (deque) {
            dq2.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Deque<T> dq2 = this.deque;
        Yx<T> a2 = this.actual;
        do {
            boolean d2;
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                boolean empty2;
                T v2;
                if (this.cancelled) {
                    this.clear(dq2);
                    return;
                }
                d2 = this.done;
                Deque<T> deque = dq2;
                synchronized (deque) {
                    v2 = dq2.poll();
                }
                boolean bl2 = empty2 = v2 == null;
                if (d2) {
                    Throwable ex2 = this.error;
                    if (ex2 != null) {
                        this.clear(dq2);
                        a2.onError(ex2);
                        return;
                    }
                    if (empty2) {
                        a2.onComplete();
                        return;
                    }
                }
                if (empty2) break;
                a2.onNext(v2);
            }
            if (e2 == r2) {
                boolean empty;
                if (this.cancelled) {
                    this.clear(dq2);
                    return;
                }
                d2 = this.done;
                Deque<T> empty2 = dq2;
                synchronized (empty2) {
                    empty = dq2.isEmpty();
                }
                if (d2) {
                    Throwable ex3 = this.error;
                    if (ex3 != null) {
                        this.clear(dq2);
                        a2.onError(ex3);
                        return;
                    }
                    if (empty) {
                        a2.onComplete();
                        return;
                    }
                }
            }
            if (e2 == 0L) continue;
            BackpressureHelper.produced(this.requested, e2);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }
}

