/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Action;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableOnBackpressureBuffer$BackpressureBufferSubscriber<T>
extends BasicIntQueueSubscription<T>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -2514538129242366402L;
    final Yx<? super T> actual;
    final SimplePlainQueue<T> queue;
    final boolean delayError;
    final Action onOverflow;
    Yy s;
    volatile boolean cancelled;
    volatile boolean done;
    Throwable error;
    final AtomicLong requested = new AtomicLong();
    boolean outputFused;

    FlowableOnBackpressureBuffer$BackpressureBufferSubscriber(Yx<? super T> actual, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow) {
        this.actual = actual;
        this.onOverflow = onOverflow;
        this.delayError = delayError;
        SimplePlainQueue<Object> q2 = unbounded ? new SpscLinkedArrayQueue(bufferSize) : new SpscArrayQueue(bufferSize);
        this.queue = q2;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.queue.offer(t2)) {
            this.s.cancel();
            MissingBackpressureException ex2 = new MissingBackpressureException("Buffer is full");
            try {
                this.onOverflow.run();
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                ex2.initCause(e2);
            }
            this.onError(ex2);
            return;
        }
        if (this.outputFused) {
            this.actual.onNext(null);
        } else {
            this.drain();
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.error = t2;
        this.done = true;
        if (this.outputFused) {
            this.actual.onError(t2);
        } else {
            this.drain();
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        if (this.outputFused) {
            this.actual.onComplete();
        } else {
            this.drain();
        }
    }

    @Override
    public void request(long n2) {
        if (!this.outputFused && SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    void drain() {
        block5: {
            if (this.getAndIncrement() != 0) break block5;
            int missed = 1;
            SimplePlainQueue<T> q2 = this.queue;
            Yx<T> a2 = this.actual;
            do {
                boolean empty;
                boolean d2;
                long e2;
                if (this.checkTerminated(this.done, q2.isEmpty(), a2)) {
                    return;
                }
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean empty2;
                    d2 = this.done;
                    T v2 = q2.poll();
                    boolean bl2 = empty2 = v2 == null;
                    if (this.checkTerminated(d2, empty2, a2)) {
                        return;
                    }
                    if (empty2) break;
                    a2.onNext(v2);
                }
                if (e2 == r2 && this.checkTerminated(d2 = this.done, empty = q2.isEmpty(), a2)) {
                    return;
                }
                if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e2);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }

    boolean checkTerminated(boolean d2, boolean empty, Yx<? super T> a2) {
        if (this.cancelled) {
            this.queue.clear();
            return true;
        }
        if (d2) {
            if (this.delayError) {
                if (empty) {
                    Throwable e2 = this.error;
                    if (e2 != null) {
                        a2.onError(e2);
                    } else {
                        a2.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable e3 = this.error;
                if (e3 != null) {
                    this.queue.clear();
                    a2.onError(e3);
                    return true;
                }
                if (empty) {
                    a2.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    @Nullable
    public T poll() {
        return this.queue.poll();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }
}

