/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler$Worker;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableObserveOn$BaseObserveOnSubscriber;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;

final class FlowableObserveOn$ObserveOnSubscriber<T>
extends FlowableObserveOn$BaseObserveOnSubscriber<T>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -4547113800637756442L;
    final Yx<? super T> actual;

    FlowableObserveOn$ObserveOnSubscriber(Yx<? super T> actual, Scheduler$Worker worker, boolean delayError, int prefetch) {
        super(worker, delayError, prefetch);
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            if (s2 instanceof QueueSubscription) {
                QueueSubscription f2 = (QueueSubscription)s2;
                int m2 = f2.requestFusion(7);
                if (m2 == 1) {
                    this.sourceMode = 1;
                    this.queue = f2;
                    this.done = true;
                    this.actual.onSubscribe(this);
                    return;
                }
                if (m2 == 2) {
                    this.sourceMode = 2;
                    this.queue = f2;
                    this.actual.onSubscribe(this);
                    s2.request(this.prefetch);
                    return;
                }
            }
            this.queue = new SpscArrayQueue(this.prefetch);
            this.actual.onSubscribe(this);
            s2.request(this.prefetch);
        }
    }

    @Override
    void runSync() {
        int missed = 1;
        Yx a2 = this.actual;
        SimpleQueue q2 = this.queue;
        long e2 = this.produced;
        while (true) {
            long r2 = this.requested.get();
            while (e2 != r2) {
                Object v2;
                try {
                    v2 = q2.poll();
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.s.cancel();
                    a2.onError(ex2);
                    this.worker.dispose();
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (v2 == null) {
                    a2.onComplete();
                    this.worker.dispose();
                    return;
                }
                a2.onNext(v2);
                ++e2;
            }
            if (this.cancelled) {
                return;
            }
            if (q2.isEmpty()) {
                a2.onComplete();
                this.worker.dispose();
                return;
            }
            int w2 = this.get();
            if (missed == w2) {
                this.produced = e2;
                if ((missed = this.addAndGet(-missed)) != 0) continue;
                break;
            }
            missed = w2;
        }
    }

    @Override
    void runAsync() {
        int missed = 1;
        Yx a2 = this.actual;
        SimpleQueue q2 = this.queue;
        long e2 = this.produced;
        while (true) {
            long r2 = this.requested.get();
            while (e2 != r2) {
                boolean empty;
                Object v2;
                boolean d2 = this.done;
                try {
                    v2 = q2.poll();
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.s.cancel();
                    q2.clear();
                    a2.onError(ex2);
                    this.worker.dispose();
                    return;
                }
                boolean bl2 = empty = v2 == null;
                if (this.checkTerminated(d2, empty, a2)) {
                    return;
                }
                if (empty) break;
                a2.onNext(v2);
                if (++e2 != (long)this.limit) continue;
                if (r2 != Long.MAX_VALUE) {
                    r2 = this.requested.addAndGet(-e2);
                }
                this.s.request(e2);
                e2 = 0L;
            }
            if (e2 == r2 && this.checkTerminated(this.done, q2.isEmpty(), a2)) {
                return;
            }
            int w2 = this.get();
            if (missed == w2) {
                this.produced = e2;
                if ((missed = this.addAndGet(-missed)) != 0) continue;
                break;
            }
            missed = w2;
        }
    }

    @Override
    void runBackfused() {
        int missed = 1;
        do {
            if (this.cancelled) {
                return;
            }
            boolean d2 = this.done;
            this.actual.onNext(null);
            if (!d2) continue;
            Throwable e2 = this.error;
            if (e2 != null) {
                this.actual.onError(e2);
            } else {
                this.actual.onComplete();
            }
            this.worker.dispose();
            return;
        } while ((missed = this.addAndGet(-missed)) != 0);
    }

    @Override
    @Nullable
    public T poll() {
        Object v2 = this.queue.poll();
        if (v2 != null && this.sourceMode != 1) {
            long p2 = this.produced + 1L;
            if (p2 == (long)this.limit) {
                this.produced = 0L;
                this.s.request(p2);
            } else {
                this.produced = p2;
            }
        }
        return v2;
    }
}

