/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscribers.SinglePostCompleteSubscriber;
import java.util.concurrent.Callable;

final class FlowableMapNotification$MapNotificationSubscriber<T, R>
extends SinglePostCompleteSubscriber<T, R> {
    private static final long serialVersionUID = 2757120512858778108L;
    final Function<? super T, ? extends R> onNextMapper;
    final Function<? super Throwable, ? extends R> onErrorMapper;
    final Callable<? extends R> onCompleteSupplier;

    FlowableMapNotification$MapNotificationSubscriber(Yx<? super R> actual, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Callable<? extends R> onCompleteSupplier) {
        super(actual);
        this.onNextMapper = onNextMapper;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteSupplier = onCompleteSupplier;
    }

    @Override
    public void onNext(T t2) {
        R p2;
        try {
            p2 = ObjectHelper.requireNonNull(this.onNextMapper.apply(t2), "The onNext publisher returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            return;
        }
        ++this.produced;
        this.actual.onNext(p2);
    }

    @Override
    public void onError(Throwable t2) {
        R p2;
        try {
            p2 = ObjectHelper.requireNonNull(this.onErrorMapper.apply(t2), "The onError publisher returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(new CompositeException(t2, e2));
            return;
        }
        this.complete(p2);
    }

    @Override
    public void onComplete() {
        R p2;
        try {
            p2 = ObjectHelper.requireNonNull(this.onCompleteSupplier.call(), "The onComplete publisher returned is null");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.actual.onError(e2);
            return;
        }
        this.complete(p2);
    }
}

