/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.annotations.Nullable;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscribers.BasicFuseableConditionalSubscriber;

final class FlowableMap$MapConditionalSubscriber<T, U>
extends BasicFuseableConditionalSubscriber<T, U> {
    final Function<? super T, ? extends U> mapper;

    FlowableMap$MapConditionalSubscriber(ConditionalSubscriber<? super U> actual, Function<? super T, ? extends U> function) {
        super(actual);
        this.mapper = function;
    }

    @Override
    public void onNext(T t2) {
        U v2;
        if (this.done) {
            return;
        }
        if (this.sourceMode != 0) {
            this.actual.onNext(null);
            return;
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.");
        }
        catch (Throwable ex2) {
            this.fail(ex2);
            return;
        }
        this.actual.onNext(v2);
    }

    @Override
    public boolean tryOnNext(T t2) {
        U v2;
        if (this.done) {
            return false;
        }
        try {
            v2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.");
        }
        catch (Throwable ex2) {
            this.fail(ex2);
            return true;
        }
        return this.actual.tryOnNext(v2);
    }

    @Override
    public int requestFusion(int mode) {
        return this.transitiveBoundaryFusion(mode);
    }

    @Override
    @Nullable
    public U poll() {
        Object t2 = this.qs.poll();
        return t2 != null ? (U)ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper function returned a null value.") : null;
    }
}

