/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableLimit$LimitSubscriber<T>
extends AtomicLong
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = 2288246011222124525L;
    final Yx<? super T> actual;
    long remaining;
    Yy upstream;

    FlowableLimit$LimitSubscriber(Yx<? super T> actual, long remaining) {
        this.actual = actual;
        this.remaining = remaining;
        this.lazySet(remaining);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.upstream, s2)) {
            if (this.remaining == 0L) {
                s2.cancel();
                EmptySubscription.complete(this.actual);
            } else {
                this.upstream = s2;
                this.actual.onSubscribe(this);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        long r2 = this.remaining;
        if (r2 > 0L) {
            this.remaining = --r2;
            this.actual.onNext(t2);
            if (r2 == 0L) {
                this.upstream.cancel();
                this.actual.onComplete();
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.remaining > 0L) {
            this.remaining = 0L;
            this.actual.onError(t2);
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.remaining > 0L) {
            this.remaining = 0L;
            this.actual.onComplete();
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            long r2;
            while ((r2 = this.get()) != 0L) {
                long toRequest = r2 <= n2 ? r2 : n2;
                long u2 = r2 - toRequest;
                if (!this.compareAndSet(r2, u2)) continue;
                this.upstream.request(toRequest);
                break;
            }
        }
    }

    @Override
    public void cancel() {
        this.upstream.cancel();
    }
}

