/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableGroupJoin$JoinSupport;
import io.reactivex.internal.operators.flowable.FlowableGroupJoin$LeftRightEndSubscriber;
import io.reactivex.internal.operators.flowable.FlowableGroupJoin$LeftRightSubscriber;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.UnicastProcessor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableGroupJoin$GroupJoinSubscription<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends AtomicInteger
implements Yy,
FlowableGroupJoin$JoinSupport {
    private static final long serialVersionUID = -6071216598687999801L;
    final Yx<? super R> actual;
    final AtomicLong requested;
    final SpscLinkedArrayQueue<Object> queue;
    final CompositeDisposable disposables;
    final Map<Integer, UnicastProcessor<TRight>> lefts;
    final Map<Integer, TRight> rights;
    final AtomicReference<Throwable> error;
    final Function<? super TLeft, ? extends Yw<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends Yw<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super Flowable<TRight>, ? extends R> resultSelector;
    final AtomicInteger active;
    int leftIndex;
    int rightIndex;
    volatile boolean cancelled;
    static final Integer LEFT_VALUE = 1;
    static final Integer RIGHT_VALUE = 2;
    static final Integer LEFT_CLOSE = 3;
    static final Integer RIGHT_CLOSE = 4;

    FlowableGroupJoin$GroupJoinSubscription(Yx<? super R> actual, Function<? super TLeft, ? extends Yw<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Yw<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super Flowable<TRight>, ? extends R> resultSelector) {
        this.actual = actual;
        this.requested = new AtomicLong();
        this.disposables = new CompositeDisposable();
        this.queue = new SpscLinkedArrayQueue(Flowable.bufferSize());
        this.lefts = new LinkedHashMap<Integer, UnicastProcessor<TRight>>();
        this.rights = new LinkedHashMap<Integer, TRight>();
        this.error = new AtomicReference();
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.resultSelector = resultSelector;
        this.active = new AtomicInteger(2);
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
        }
    }

    @Override
    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.cancelAll();
        if (this.getAndIncrement() == 0) {
            this.queue.clear();
        }
    }

    void cancelAll() {
        this.disposables.dispose();
    }

    void errorAll(Yx<?> a2) {
        Throwable ex2 = ExceptionHelper.terminate(this.error);
        for (UnicastProcessor<TRight> up2 : this.lefts.values()) {
            up2.onError(ex2);
        }
        this.lefts.clear();
        this.rights.clear();
        a2.onError(ex2);
    }

    void fail(Throwable exc, Yx<?> a2, SimpleQueue<?> q2) {
        Exceptions.throwIfFatal(exc);
        ExceptionHelper.addThrowable(this.error, exc);
        q2.clear();
        this.cancelAll();
        this.errorAll(a2);
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        SpscLinkedArrayQueue<Object> q2 = this.queue;
        Yx<R> a2 = this.actual;
        block6: while (true) {
            boolean empty;
            if (this.cancelled) {
                q2.clear();
                return;
            }
            Throwable ex2 = this.error.get();
            if (ex2 != null) {
                q2.clear();
                this.cancelAll();
                this.errorAll(a2);
                return;
            }
            boolean d2 = this.active.get() == 0;
            Integer mode = (Integer)q2.poll();
            boolean bl2 = empty = mode == null;
            if (d2 && empty) {
                for (UnicastProcessor<TRight> up2 : this.lefts.values()) {
                    up2.onComplete();
                }
                this.lefts.clear();
                this.rights.clear();
                this.disposables.dispose();
                a2.onComplete();
                return;
            }
            if (!empty) {
                FlowableGroupJoin$LeftRightEndSubscriber end;
                Object val = q2.poll();
                if (mode == LEFT_VALUE) {
                    R w2;
                    Yw<TLeftEnd> p2;
                    int idx;
                    Object left = val;
                    UnicastProcessor<TRight> up3 = UnicastProcessor.create();
                    ++this.leftIndex;
                    this.lefts.put(idx, up3);
                    try {
                        p2 = ObjectHelper.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null Publisher");
                    }
                    catch (Throwable exc) {
                        this.fail(exc, a2, q2);
                        return;
                    }
                    FlowableGroupJoin$LeftRightEndSubscriber end2 = new FlowableGroupJoin$LeftRightEndSubscriber(this, true, idx);
                    this.disposables.add(end2);
                    p2.subscribe(end2);
                    ex2 = this.error.get();
                    if (ex2 != null) {
                        q2.clear();
                        this.cancelAll();
                        this.errorAll(a2);
                        return;
                    }
                    try {
                        w2 = ObjectHelper.requireNonNull(this.resultSelector.apply(left, up3), "The resultSelector returned a null value");
                    }
                    catch (Throwable exc) {
                        this.fail(exc, a2, q2);
                        return;
                    }
                    if (this.requested.get() == 0L) {
                        this.fail(new MissingBackpressureException("Could not emit value due to lack of requests"), a2, q2);
                        return;
                    }
                    a2.onNext(w2);
                    BackpressureHelper.produced(this.requested, 1L);
                    Iterator<TRight> iterator = this.rights.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block6;
                        TRight right = iterator.next();
                        up3.onNext(right);
                    }
                }
                if (mode == RIGHT_VALUE) {
                    Yw<TRightEnd> p3;
                    int idx;
                    Object right = val;
                    ++this.rightIndex;
                    this.rights.put(idx, right);
                    try {
                        p3 = ObjectHelper.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null Publisher");
                    }
                    catch (Throwable exc) {
                        this.fail(exc, a2, q2);
                        return;
                    }
                    FlowableGroupJoin$LeftRightEndSubscriber end3 = new FlowableGroupJoin$LeftRightEndSubscriber(this, false, idx);
                    this.disposables.add(end3);
                    p3.subscribe(end3);
                    ex2 = this.error.get();
                    if (ex2 != null) {
                        q2.clear();
                        this.cancelAll();
                        this.errorAll(a2);
                        return;
                    }
                    Iterator<UnicastProcessor<TRight>> iterator = this.lefts.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block6;
                        UnicastProcessor<TRight> up4 = iterator.next();
                        up4.onNext(right);
                    }
                }
                if (mode == LEFT_CLOSE) {
                    end = (FlowableGroupJoin$LeftRightEndSubscriber)val;
                    UnicastProcessor<TRight> up5 = this.lefts.remove(end.index);
                    this.disposables.remove(end);
                    if (up5 == null) continue;
                    up5.onComplete();
                    continue;
                }
                if (mode != RIGHT_CLOSE) continue;
                end = (FlowableGroupJoin$LeftRightEndSubscriber)val;
                this.rights.remove(end.index);
                this.disposables.remove(end);
                continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }

    @Override
    public void innerError(Throwable ex2) {
        if (ExceptionHelper.addThrowable(this.error, ex2)) {
            this.active.decrementAndGet();
            this.drain();
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }

    @Override
    public void innerComplete(FlowableGroupJoin$LeftRightSubscriber sender) {
        this.disposables.delete(sender);
        this.active.decrementAndGet();
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void innerValue(boolean isLeft, Object o2) {
        FlowableGroupJoin$GroupJoinSubscription flowableGroupJoin$GroupJoinSubscription = this;
        synchronized (flowableGroupJoin$GroupJoinSubscription) {
            this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o2);
        }
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void innerClose(boolean isLeft, FlowableGroupJoin$LeftRightEndSubscriber index) {
        FlowableGroupJoin$GroupJoinSubscription flowableGroupJoin$GroupJoinSubscription = this;
        synchronized (flowableGroupJoin$GroupJoinSubscription) {
            this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
        }
        this.drain();
    }

    @Override
    public void innerCloseError(Throwable ex2) {
        if (ExceptionHelper.addThrowable(this.error, ex2)) {
            this.drain();
        } else {
            RxJavaPlugins.onError(ex2);
        }
    }
}

