/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.annotations.Nullable;
import io.reactivex.internal.operators.flowable.FlowableGroupBy$GroupBySubscriber;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableGroupBy$State<T, K>
extends BasicIntQueueSubscription<T>
implements Yw<T> {
    private static final long serialVersionUID = -3852313036005250360L;
    final K key;
    final SpscLinkedArrayQueue<T> queue;
    final FlowableGroupBy$GroupBySubscriber<?, K, T> parent;
    final boolean delayError;
    final AtomicLong requested = new AtomicLong();
    volatile boolean done;
    Throwable error;
    final AtomicBoolean cancelled = new AtomicBoolean();
    final AtomicReference<Yx<? super T>> actual = new AtomicReference();
    final AtomicBoolean once = new AtomicBoolean();
    boolean outputFused;
    int produced;

    FlowableGroupBy$State(int bufferSize, FlowableGroupBy$GroupBySubscriber<?, K, T> parent, K key, boolean delayError) {
        this.queue = new SpscLinkedArrayQueue(bufferSize);
        this.parent = parent;
        this.key = key;
        this.delayError = delayError;
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            this.parent.cancel(this.key);
        }
    }

    @Override
    public void subscribe(Yx<? super T> s2) {
        if (this.once.compareAndSet(false, true)) {
            s2.onSubscribe(this);
            this.actual.lazySet(s2);
            this.drain();
        } else {
            EmptySubscription.error(new IllegalStateException("Only one Subscriber allowed!"), s2);
        }
    }

    public void onNext(T t2) {
        this.queue.offer(t2);
        this.drain();
    }

    public void onError(Throwable e2) {
        this.error = e2;
        this.done = true;
        this.drain();
    }

    public void onComplete() {
        this.done = true;
        this.drain();
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        if (this.outputFused) {
            this.drainFused();
        } else {
            this.drainNormal();
        }
    }

    void drainFused() {
        int missed = 1;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        Yx<T> a2 = this.actual.get();
        while (true) {
            if (a2 != null) {
                Throwable ex2;
                if (this.cancelled.get()) {
                    q2.clear();
                    return;
                }
                boolean d2 = this.done;
                if (d2 && !this.delayError && (ex2 = this.error) != null) {
                    q2.clear();
                    a2.onError(ex2);
                    return;
                }
                a2.onNext(null);
                if (d2) {
                    ex2 = this.error;
                    if (ex2 != null) {
                        a2.onError(ex2);
                    } else {
                        a2.onComplete();
                    }
                    return;
                }
            }
            if ((missed = this.addAndGet(-missed)) == 0) {
                return;
            }
            if (a2 != null) continue;
            a2 = this.actual.get();
        }
    }

    void drainNormal() {
        int missed = 1;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        boolean delayError = this.delayError;
        Yx<T> a2 = this.actual.get();
        while (true) {
            if (a2 != null) {
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    boolean empty;
                    boolean d2 = this.done;
                    T v2 = q2.poll();
                    boolean bl2 = empty = v2 == null;
                    if (this.checkTerminated(d2, empty, a2, delayError)) {
                        return;
                    }
                    if (empty) break;
                    a2.onNext(v2);
                }
                if (e2 == r2 && this.checkTerminated(this.done, q2.isEmpty(), a2, delayError)) {
                    return;
                }
                if (e2 != 0L) {
                    if (r2 != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e2);
                    }
                    this.parent.s.request(e2);
                }
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
            if (a2 != null) continue;
            a2 = this.actual.get();
        }
    }

    boolean checkTerminated(boolean d2, boolean empty, Yx<? super T> a2, boolean delayError) {
        if (this.cancelled.get()) {
            this.queue.clear();
            return true;
        }
        if (d2) {
            if (delayError) {
                if (empty) {
                    Throwable e2 = this.error;
                    if (e2 != null) {
                        a2.onError(e2);
                    } else {
                        a2.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable e3 = this.error;
                if (e3 != null) {
                    this.queue.clear();
                    a2.onError(e3);
                    return true;
                }
                if (empty) {
                    a2.onComplete();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.outputFused = true;
            return 2;
        }
        return 0;
    }

    @Override
    @Nullable
    public T poll() {
        T v2 = this.queue.poll();
        if (v2 != null) {
            ++this.produced;
            return v2;
        }
        int p2 = this.produced;
        if (p2 != 0) {
            this.produced = 0;
            this.parent.s.request(p2);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }
}

