/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Emitter;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableGenerate$GeneratorSubscription<T, S>
extends AtomicLong
implements Yy,
Emitter<T> {
    private static final long serialVersionUID = 7565982551505011832L;
    final Yx<? super T> actual;
    final BiFunction<S, ? super Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;
    S state;
    volatile boolean cancelled;
    boolean terminate;
    boolean hasNext;

    FlowableGenerate$GeneratorSubscription(Yx<? super T> actual, BiFunction<S, ? super Emitter<T>, S> generator, Consumer<? super S> disposeState, S initialState) {
        this.actual = actual;
        this.generator = generator;
        this.disposeState = disposeState;
        this.state = initialState;
    }

    @Override
    public void request(long n2) {
        if (!SubscriptionHelper.validate(n2)) {
            return;
        }
        if (BackpressureHelper.add(this, n2) != 0L) {
            return;
        }
        long e2 = 0L;
        S s2 = this.state;
        BiFunction<S, Emitter<T>, S> f2 = this.generator;
        while (true) {
            if (e2 != n2) {
                if (this.cancelled) {
                    this.state = null;
                    this.dispose(s2);
                    return;
                }
                this.hasNext = false;
                try {
                    s2 = f2.apply(s2, this);
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.cancelled = true;
                    this.state = null;
                    this.onError(ex2);
                    this.dispose(s2);
                    return;
                }
                if (this.terminate) {
                    this.cancelled = true;
                    this.state = null;
                    this.dispose(s2);
                    return;
                }
                ++e2;
                continue;
            }
            n2 = this.get();
            if (e2 != n2) continue;
            this.state = s2;
            n2 = this.addAndGet(-e2);
            if (n2 == 0L) break;
            e2 = 0L;
        }
    }

    private void dispose(S s2) {
        try {
            this.disposeState.accept(s2);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            RxJavaPlugins.onError(ex2);
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            if (BackpressureHelper.add(this, 1L) == 0L) {
                S s2 = this.state;
                this.state = null;
                this.dispose(s2);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        if (!this.terminate) {
            if (this.hasNext) {
                this.onError(new IllegalStateException("onNext already called in this generate turn"));
            } else if (t2 == null) {
                this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            } else {
                this.hasNext = true;
                this.actual.onNext(t2);
            }
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.terminate) {
            RxJavaPlugins.onError(t2);
        } else {
            if (t2 == null) {
                t2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
            }
            this.terminate = true;
            this.actual.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (!this.terminate) {
            this.terminate = true;
            this.actual.onComplete();
        }
    }
}

