/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.operators.flowable.FlowableFromIterable$IteratorConditionalSubscription;
import io.reactivex.internal.operators.flowable.FlowableFromIterable$IteratorSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Iterator;

public final class FlowableFromIterable<T>
extends Flowable<T> {
    final Iterable<? extends T> source;

    public FlowableFromIterable(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        Iterator<? extends T> it2;
        try {
            it2 = this.source.iterator();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptySubscription.error(e2, s2);
            return;
        }
        FlowableFromIterable.subscribe(s2, it2);
    }

    public static <T> void subscribe(Yx<? super T> s2, Iterator<? extends T> it2) {
        boolean hasNext;
        try {
            hasNext = it2.hasNext();
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            EmptySubscription.error(e2, s2);
            return;
        }
        if (!hasNext) {
            EmptySubscription.complete(s2);
            return;
        }
        if (s2 instanceof ConditionalSubscriber) {
            s2.onSubscribe(new FlowableFromIterable$IteratorConditionalSubscription<T>((ConditionalSubscriber)s2, it2));
        } else {
            s2.onSubscribe(new FlowableFromIterable$IteratorSubscription<T>(s2, it2));
        }
    }
}

