/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import java.util.concurrent.Callable;

public final class FlowableFromCallable<T>
extends Flowable<T>
implements Callable<T> {
    final Callable<? extends T> callable;

    public FlowableFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribeActual(Yx<? super T> s2) {
        T t2;
        DeferredScalarSubscription<T> deferred = new DeferredScalarSubscription<T>(s2);
        s2.onSubscribe(deferred);
        try {
            t2 = ObjectHelper.requireNonNull(this.callable.call(), "The callable returned a null value");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            s2.onError(ex2);
            return;
        }
        deferred.complete(t2);
    }

    @Override
    public T call() {
        return ObjectHelper.requireNonNull(this.callable.call(), "The callable returned a null value");
    }
}

