/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableFlattenIterable$FlattenIterableSubscriber<T, R>
extends BasicIntQueueSubscription<R>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -3096000382929934955L;
    final Yx<? super R> actual;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    final int prefetch;
    final int limit;
    final AtomicLong requested;
    Yy s;
    SimpleQueue<T> queue;
    volatile boolean done;
    volatile boolean cancelled;
    final AtomicReference<Throwable> error;
    Iterator<? extends R> current;
    int consumed;
    int fusionMode;

    FlowableFlattenIterable$FlattenIterableSubscriber(Yx<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        this.actual = actual;
        this.mapper = mapper;
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
        this.error = new AtomicReference();
        this.requested = new AtomicLong();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs2 = (QueueSubscription)s2;
                int m2 = qs2.requestFusion(3);
                if (m2 == 1) {
                    this.fusionMode = m2;
                    this.queue = qs2;
                    this.done = true;
                    this.actual.onSubscribe(this);
                    return;
                }
                if (m2 == 2) {
                    this.fusionMode = m2;
                    this.queue = qs2;
                    this.actual.onSubscribe(this);
                    s2.request(this.prefetch);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.prefetch);
            this.actual.onSubscribe(this);
            s2.request(this.prefetch);
        }
    }

    @Override
    public void onNext(T t2) {
        if (this.done) {
            return;
        }
        if (this.fusionMode == 0 && !this.queue.offer(t2)) {
            this.onError(new MissingBackpressureException("Queue is full?!"));
            return;
        }
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        if (!this.done && ExceptionHelper.addThrowable(this.error, t2)) {
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }
    }

    void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Yx<R> a2 = this.actual;
        SimpleQueue<T> q2 = this.queue;
        boolean replenish = this.fusionMode != 1;
        int missed = 1;
        Iterator<R> it2 = this.current;
        while (true) {
            if (it2 == null) {
                boolean empty;
                T t2;
                boolean d2 = this.done;
                try {
                    t2 = q2.poll();
                }
                catch (Throwable ex2) {
                    Exceptions.throwIfFatal(ex2);
                    this.s.cancel();
                    ExceptionHelper.addThrowable(this.error, ex2);
                    ex2 = ExceptionHelper.terminate(this.error);
                    this.current = null;
                    q2.clear();
                    a2.onError(ex2);
                    return;
                }
                boolean bl2 = empty = t2 == null;
                if (this.checkTerminated(d2, empty, a2, q2)) {
                    return;
                }
                if (t2 != null) {
                    boolean b2;
                    try {
                        Iterable<R> iterable = this.mapper.apply(t2);
                        it2 = iterable.iterator();
                        b2 = it2.hasNext();
                    }
                    catch (Throwable ex3) {
                        Exceptions.throwIfFatal(ex3);
                        this.s.cancel();
                        ExceptionHelper.addThrowable(this.error, ex3);
                        ex3 = ExceptionHelper.terminate(this.error);
                        a2.onError(ex3);
                        return;
                    }
                    if (!b2) {
                        it2 = null;
                        this.consumedOne(replenish);
                        continue;
                    }
                    this.current = it2;
                }
            }
            if (it2 != null) {
                long e2;
                long r2 = this.requested.get();
                for (e2 = 0L; e2 != r2; ++e2) {
                    R v2;
                    if (this.checkTerminated(this.done, false, a2, q2)) {
                        return;
                    }
                    try {
                        v2 = ObjectHelper.requireNonNull(it2.next(), "The iterator returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.current = null;
                        this.s.cancel();
                        ExceptionHelper.addThrowable(this.error, ex4);
                        ex4 = ExceptionHelper.terminate(this.error);
                        a2.onError(ex4);
                        return;
                    }
                    a2.onNext(v2);
                    if (this.checkTerminated(this.done, false, a2, q2)) {
                        return;
                    }
                    try {
                        boolean b3 = it2.hasNext();
                        continue;
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        this.current = null;
                        this.s.cancel();
                        ExceptionHelper.addThrowable(this.error, ex5);
                        ex5 = ExceptionHelper.terminate(this.error);
                        a2.onError(ex5);
                        return;
                    }
                }
                if (e2 == r2) {
                    boolean empty;
                    boolean d3 = this.done;
                    boolean bl3 = empty = q2.isEmpty() && it2 == null;
                    if (this.checkTerminated(d3, empty, a2, q2)) {
                        return;
                    }
                }
                if (e2 != 0L && r2 != Long.MAX_VALUE) {
                    this.requested.addAndGet(-e2);
                }
                if (it2 == null) continue;
            }
            if ((missed = this.addAndGet(-missed)) == 0) break;
        }
    }

    void consumedOne(boolean enabled) {
        if (enabled) {
            int c2 = this.consumed + 1;
            if (c2 == this.limit) {
                this.consumed = 0;
                this.s.request(c2);
            } else {
                this.consumed = c2;
            }
        }
    }

    boolean checkTerminated(boolean d2, boolean empty, Yx<?> a2, SimpleQueue<?> q2) {
        if (this.cancelled) {
            this.current = null;
            q2.clear();
            return true;
        }
        if (d2) {
            Throwable ex2 = this.error.get();
            if (ex2 != null) {
                ex2 = ExceptionHelper.terminate(this.error);
                this.current = null;
                q2.clear();
                a2.onError(ex2);
                return true;
            }
            if (empty) {
                a2.onComplete();
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.current = null;
        this.queue.clear();
    }

    @Override
    public boolean isEmpty() {
        Iterator<R> it2 = this.current;
        if (it2 == null) {
            return this.queue.isEmpty();
        }
        return !it2.hasNext();
    }

    @Override
    @Nullable
    public R poll() {
        Iterator<R> it2 = this.current;
        while (it2 == null) {
            T v2 = this.queue.poll();
            if (v2 == null) {
                return null;
            }
            it2 = this.mapper.apply(v2).iterator();
            if (!it2.hasNext()) {
                it2 = null;
                continue;
            }
            this.current = it2;
            break;
        }
        R r2 = ObjectHelper.requireNonNull(it2.next(), "The iterator returned a null value");
        if (!it2.hasNext()) {
            this.current = null;
        }
        return r2;
    }

    @Override
    public int requestFusion(int requestedMode) {
        if ((requestedMode & 1) != 0 && this.fusionMode == 1) {
            return 1;
        }
        return 0;
    }
}

