/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableFlatMapSingle$FlatMapSingleSubscriber$InnerObserver;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableFlatMapSingle$FlatMapSingleSubscriber<T, R>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = 8600231336733376951L;
    final Yx<? super R> actual;
    final boolean delayErrors;
    final int maxConcurrency;
    final AtomicLong requested;
    final CompositeDisposable set;
    final AtomicInteger active;
    final AtomicThrowable errors;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;
    final AtomicReference<SpscLinkedArrayQueue<R>> queue;
    Yy s;
    volatile boolean cancelled;

    FlowableFlatMapSingle$FlatMapSingleSubscriber(Yx<? super R> actual, Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        this.actual = actual;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.requested = new AtomicLong();
        this.set = new CompositeDisposable();
        this.errors = new AtomicThrowable();
        this.active = new AtomicInteger(1);
        this.queue = new AtomicReference();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            int m2 = this.maxConcurrency;
            if (m2 == Integer.MAX_VALUE) {
                s2.request(Long.MAX_VALUE);
            } else {
                s2.request(this.maxConcurrency);
            }
        }
    }

    @Override
    public void onNext(T t2) {
        SingleSource<R> ms2;
        try {
            ms2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper returned a null SingleSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.s.cancel();
            this.onError(ex2);
            return;
        }
        this.active.getAndIncrement();
        FlowableFlatMapSingle$FlatMapSingleSubscriber$InnerObserver inner = new FlowableFlatMapSingle$FlatMapSingleSubscriber$InnerObserver(this);
        if (!this.cancelled && this.set.add(inner)) {
            ms2.subscribe(inner);
        }
    }

    @Override
    public void onError(Throwable t2) {
        this.active.decrementAndGet();
        if (this.errors.addThrowable(t2)) {
            if (!this.delayErrors) {
                this.set.dispose();
            }
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        this.active.decrementAndGet();
        this.drain();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.s.cancel();
        this.set.dispose();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void innerSuccess(FlowableFlatMapSingle$FlatMapSingleSubscriber$InnerObserver inner, R value) {
        this.set.delete(inner);
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            boolean d2;
            boolean bl2 = d2 = this.active.decrementAndGet() == 0;
            if (this.requested.get() != 0L) {
                this.actual.onNext(value);
                SpscLinkedArrayQueue<R> q2 = this.queue.get();
                if (d2 && (q2 == null || q2.isEmpty())) {
                    Throwable ex2 = this.errors.terminate();
                    if (ex2 != null) {
                        this.actual.onError(ex2);
                    } else {
                        this.actual.onComplete();
                    }
                    return;
                }
                BackpressureHelper.produced(this.requested, 1L);
                if (this.maxConcurrency != Integer.MAX_VALUE) {
                    this.s.request(1L);
                }
            } else {
                SpscLinkedArrayQueue<R> q3;
                SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q3 = this.getOrCreateQueue();
                synchronized (spscLinkedArrayQueue) {
                    q3.offer(value);
                }
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
        } else {
            SpscLinkedArrayQueue<R> q4;
            SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q4 = this.getOrCreateQueue();
            synchronized (spscLinkedArrayQueue) {
                q4.offer(value);
            }
            this.active.decrementAndGet();
            if (this.getAndIncrement() != 0) {
                return;
            }
        }
        this.drainLoop();
    }

    SpscLinkedArrayQueue<R> getOrCreateQueue() {
        SpscLinkedArrayQueue<Object> current;
        do {
            if ((current = this.queue.get()) == null) continue;
            return current;
        } while (!this.queue.compareAndSet(null, current = new SpscLinkedArrayQueue(Flowable.bufferSize())));
        return current;
    }

    void innerError(FlowableFlatMapSingle$FlatMapSingleSubscriber$InnerObserver inner, Throwable e2) {
        this.set.delete(inner);
        if (this.errors.addThrowable(e2)) {
            if (!this.delayErrors) {
                this.s.cancel();
                this.set.dispose();
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.s.request(1L);
            }
            this.active.decrementAndGet();
            this.drain();
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    void drain() {
        if (this.getAndIncrement() == 0) {
            this.drainLoop();
        }
    }

    void clear() {
        SpscLinkedArrayQueue<R> q2 = this.queue.get();
        if (q2 != null) {
            q2.clear();
        }
    }

    void drainLoop() {
        int missed = 1;
        Yx<R> a2 = this.actual;
        AtomicInteger n2 = this.active;
        AtomicReference<SpscLinkedArrayQueue<R>> qr2 = this.queue;
        do {
            SpscLinkedArrayQueue<R> q2;
            boolean d2;
            long e2;
            long r2 = this.requested.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                boolean empty;
                Throwable ex2;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                if (!this.delayErrors && (ex2 = (Throwable)this.errors.get()) != null) {
                    ex2 = this.errors.terminate();
                    this.clear();
                    a2.onError(ex2);
                    return;
                }
                d2 = n2.get() == 0;
                q2 = qr2.get();
                Object v2 = q2 != null ? (Object)q2.poll() : null;
                boolean bl2 = empty = v2 == null;
                if (d2 && empty) {
                    Throwable ex3 = this.errors.terminate();
                    if (ex3 != null) {
                        a2.onError(ex3);
                    } else {
                        a2.onComplete();
                    }
                    return;
                }
                if (empty) break;
                a2.onNext(v2);
            }
            if (e2 == r2) {
                boolean empty;
                Throwable ex4;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                if (!this.delayErrors && (ex4 = (Throwable)this.errors.get()) != null) {
                    ex4 = this.errors.terminate();
                    this.clear();
                    a2.onError(ex4);
                    return;
                }
                d2 = n2.get() == 0;
                q2 = qr2.get();
                boolean bl3 = empty = q2 == null || q2.isEmpty();
                if (d2 && empty) {
                    Throwable ex5 = this.errors.terminate();
                    if (ex5 != null) {
                        a2.onError(ex5);
                    } else {
                        a2.onComplete();
                    }
                    return;
                }
            }
            if (e2 == 0L) continue;
            BackpressureHelper.produced(this.requested, e2);
            if (this.maxConcurrency == Integer.MAX_VALUE) continue;
            this.s.request(e2);
        } while ((missed = this.addAndGet(-missed)) != 0);
    }
}

