/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.CompletableSource;
import io.reactivex.FlowableSubscriber;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableFlatMapCompletable$FlatMapCompletableMainSubscriber$InnerConsumer;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;

final class FlowableFlatMapCompletable$FlatMapCompletableMainSubscriber<T>
extends BasicIntQueueSubscription<T>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = 8443155186132538303L;
    final Yx<? super T> actual;
    final AtomicThrowable errors;
    final Function<? super T, ? extends CompletableSource> mapper;
    final boolean delayErrors;
    final CompositeDisposable set;
    final int maxConcurrency;
    Yy s;
    volatile boolean cancelled;

    FlowableFlatMapCompletable$FlatMapCompletableMainSubscriber(Yx<? super T> observer, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors, int maxConcurrency) {
        this.actual = observer;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.errors = new AtomicThrowable();
        this.set = new CompositeDisposable();
        this.maxConcurrency = maxConcurrency;
        this.lazySet(1);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            int m2 = this.maxConcurrency;
            if (m2 == Integer.MAX_VALUE) {
                s2.request(Long.MAX_VALUE);
            } else {
                s2.request(m2);
            }
        }
    }

    @Override
    public void onNext(T value) {
        CompletableSource cs2;
        try {
            cs2 = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.s.cancel();
            this.onError(ex2);
            return;
        }
        this.getAndIncrement();
        FlowableFlatMapCompletable$FlatMapCompletableMainSubscriber$InnerConsumer inner = new FlowableFlatMapCompletable$FlatMapCompletableMainSubscriber$InnerConsumer(this);
        if (!this.cancelled && this.set.add(inner)) {
            cs2.subscribe(inner);
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (this.errors.addThrowable(e2)) {
            if (this.delayErrors) {
                if (this.decrementAndGet() == 0) {
                    Throwable ex2 = this.errors.terminate();
                    this.actual.onError(ex2);
                } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                    this.s.request(1L);
                }
            } else {
                this.cancel();
                if (this.getAndSet(0) > 0) {
                    Throwable ex3 = this.errors.terminate();
                    this.actual.onError(ex3);
                }
            }
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void onComplete() {
        if (this.decrementAndGet() == 0) {
            Throwable ex2 = this.errors.terminate();
            if (ex2 != null) {
                this.actual.onError(ex2);
            } else {
                this.actual.onComplete();
            }
        } else if (this.maxConcurrency != Integer.MAX_VALUE) {
            this.s.request(1L);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.s.cancel();
        this.set.dispose();
    }

    @Override
    public void request(long n2) {
    }

    @Override
    @Nullable
    public T poll() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public int requestFusion(int mode) {
        return mode & 2;
    }

    void innerComplete(FlowableFlatMapCompletable$FlatMapCompletableMainSubscriber$InnerConsumer inner) {
        this.set.delete(inner);
        this.onComplete();
    }

    void innerError(FlowableFlatMapCompletable$FlatMapCompletableMainSubscriber$InnerConsumer inner, Throwable e2) {
        this.set.delete(inner);
        this.onError(e2);
    }
}

