/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.FlowableFlatMap$InnerSubscriber;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableFlatMap$MergeSubscriber<T, U>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -2117620485640801370L;
    final Yx<? super U> actual;
    final Function<? super T, ? extends Yw<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;
    volatile SimplePlainQueue<U> queue;
    volatile boolean done;
    final AtomicThrowable errs = new AtomicThrowable();
    volatile boolean cancelled;
    final AtomicReference<FlowableFlatMap$InnerSubscriber<?, ?>[]> subscribers = new AtomicReference();
    static final FlowableFlatMap$InnerSubscriber<?, ?>[] EMPTY = new FlowableFlatMap$InnerSubscriber[0];
    static final FlowableFlatMap$InnerSubscriber<?, ?>[] CANCELLED = new FlowableFlatMap$InnerSubscriber[0];
    final AtomicLong requested = new AtomicLong();
    Yy upstream;
    long uniqueId;
    long lastId;
    int lastIndex;
    int scalarEmitted;
    final int scalarLimit;

    FlowableFlatMap$MergeSubscriber(Yx<? super U> actual, Function<? super T, ? extends Yw<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        this.actual = actual;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
        this.scalarLimit = Math.max(1, maxConcurrency >> 1);
        this.subscribers.lazySet(EMPTY);
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.upstream, s2)) {
            this.upstream = s2;
            this.actual.onSubscribe(this);
            if (!this.cancelled) {
                if (this.maxConcurrency == Integer.MAX_VALUE) {
                    s2.request(Long.MAX_VALUE);
                } else {
                    s2.request(this.maxConcurrency);
                }
            }
        }
    }

    @Override
    public void onNext(T t2) {
        FlowableFlatMap$InnerSubscriber inner;
        Yw<U> p2;
        if (this.done) {
            return;
        }
        try {
            p2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Publisher");
        }
        catch (Throwable e2) {
            Exceptions.throwIfFatal(e2);
            this.upstream.cancel();
            this.onError(e2);
            return;
        }
        if (p2 instanceof Callable) {
            Object u2;
            try {
                u2 = ((Callable)((Object)p2)).call();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                this.errs.addThrowable(ex2);
                this.drain();
                return;
            }
            if (u2 != null) {
                this.tryEmitScalar(u2);
            } else if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                this.scalarEmitted = 0;
                this.upstream.request(this.scalarLimit);
            }
        } else if (this.addInner(inner = new FlowableFlatMap$InnerSubscriber(this, this.uniqueId++))) {
            p2.subscribe(inner);
        }
    }

    boolean addInner(FlowableFlatMap$InnerSubscriber<T, U> inner) {
        FlowableFlatMap$InnerSubscriber[] b2;
        FlowableFlatMap$InnerSubscriber<?, ?>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == CANCELLED) {
                inner.dispose();
                return false;
            }
            int n2 = a2.length;
            b2 = new FlowableFlatMap$InnerSubscriber[n2 + 1];
            System.arraycopy(a2, 0, b2, 0, n2);
            b2[n2] = inner;
        } while (!this.subscribers.compareAndSet(a2, b2));
        return true;
    }

    void removeInner(FlowableFlatMap$InnerSubscriber<T, U> inner) {
        FlowableFlatMap$InnerSubscriber<?, ?>[] b2;
        FlowableFlatMap$InnerSubscriber<?, ?>[] a2;
        do {
            if ((a2 = this.subscribers.get()) == CANCELLED || a2 == EMPTY) {
                return;
            }
            int n2 = a2.length;
            int j2 = -1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (a2[i2] != inner) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (n2 == 1) {
                b2 = EMPTY;
                continue;
            }
            b2 = new FlowableFlatMap$InnerSubscriber[n2 - 1];
            System.arraycopy(a2, 0, b2, 0, j2);
            System.arraycopy(a2, j2 + 1, b2, j2, n2 - j2 - 1);
        } while (!this.subscribers.compareAndSet(a2, b2));
    }

    SimpleQueue<U> getMainQueue() {
        SimplePlainQueue<U> q2 = this.queue;
        if (q2 == null) {
            q2 = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
            this.queue = q2;
        }
        return q2;
    }

    void tryEmitScalar(U value) {
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            long r2 = this.requested.get();
            SimpleQueue<U> q2 = this.queue;
            if (r2 != 0L && (q2 == null || q2.isEmpty())) {
                this.actual.onNext(value);
                if (r2 != Long.MAX_VALUE) {
                    this.requested.decrementAndGet();
                }
                if (this.maxConcurrency != Integer.MAX_VALUE && !this.cancelled && ++this.scalarEmitted == this.scalarLimit) {
                    this.scalarEmitted = 0;
                    this.upstream.request(this.scalarLimit);
                }
            } else {
                if (q2 == null) {
                    q2 = this.getMainQueue();
                }
                if (!q2.offer(value)) {
                    this.onError(new IllegalStateException("Scalar queue full?!"));
                    return;
                }
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
        } else {
            SimpleQueue<U> q3 = this.getMainQueue();
            if (!q3.offer(value)) {
                this.onError(new IllegalStateException("Scalar queue full?!"));
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
        }
        this.drainLoop();
    }

    SimpleQueue<U> getInnerQueue(FlowableFlatMap$InnerSubscriber<T, U> inner) {
        SimpleQueue q2 = inner.queue;
        if (q2 == null) {
            inner.queue = q2 = new SpscArrayQueue(this.bufferSize);
        }
        return q2;
    }

    void tryEmit(U value, FlowableFlatMap$InnerSubscriber<T, U> inner) {
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            long r2 = this.requested.get();
            SimpleQueue q2 = inner.queue;
            if (r2 != 0L && (q2 == null || q2.isEmpty())) {
                this.actual.onNext(value);
                if (r2 != Long.MAX_VALUE) {
                    this.requested.decrementAndGet();
                }
                inner.requestMore(1L);
            } else {
                if (q2 == null) {
                    q2 = this.getInnerQueue(inner);
                }
                if (!q2.offer(value)) {
                    this.onError(new MissingBackpressureException("Inner queue full?!"));
                    return;
                }
            }
            if (this.decrementAndGet() == 0) {
                return;
            }
        } else {
            SimpleQueue q3 = inner.queue;
            if (q3 == null) {
                q3 = new SpscArrayQueue(this.bufferSize);
                inner.queue = q3;
            }
            if (!q3.offer(value)) {
                this.onError(new MissingBackpressureException("Inner queue full?!"));
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
        }
        this.drainLoop();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        if (this.errs.addThrowable(t2)) {
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            SimplePlainQueue<U> q2;
            this.cancelled = true;
            this.upstream.cancel();
            this.disposeAll();
            if (this.getAndIncrement() == 0 && (q2 = this.queue) != null) {
                q2.clear();
            }
        }
    }

    void drain() {
        if (this.getAndIncrement() == 0) {
            this.drainLoop();
        }
    }

    void drainLoop() {
        boolean innerCompleted;
        Yx<U> child = this.actual;
        int missed = 1;
        do {
            if (this.checkTerminate()) {
                return;
            }
            SimplePlainQueue<U> svq = this.queue;
            long r2 = this.requested.get();
            boolean unbounded = r2 == Long.MAX_VALUE;
            long replenishMain = 0L;
            if (svq != null) {
                Object o2;
                do {
                    long scalarEmission = 0L;
                    o2 = null;
                    while (r2 != 0L) {
                        o2 = svq.poll();
                        if (this.checkTerminate()) {
                            return;
                        }
                        if (o2 == null) break;
                        child.onNext(o2);
                        ++replenishMain;
                        ++scalarEmission;
                        --r2;
                    }
                    if (scalarEmission == 0L) continue;
                    r2 = unbounded ? Long.MAX_VALUE : this.requested.addAndGet(-scalarEmission);
                } while (r2 != 0L && o2 != null);
            }
            boolean d2 = this.done;
            svq = this.queue;
            FlowableFlatMap$InnerSubscriber<?, ?>[] inner = this.subscribers.get();
            int n2 = inner.length;
            if (d2 && (svq == null || svq.isEmpty()) && n2 == 0) {
                Throwable ex2 = this.errs.terminate();
                if (ex2 != ExceptionHelper.TERMINATED) {
                    if (ex2 == null) {
                        child.onComplete();
                    } else {
                        child.onError(ex2);
                    }
                }
                return;
            }
            innerCompleted = false;
            if (n2 != 0) {
                int i2;
                int j2;
                long startId = this.lastId;
                int index = this.lastIndex;
                if (n2 <= index || inner[index].id != startId) {
                    if (n2 <= index) {
                        index = 0;
                    }
                    j2 = index;
                    for (i2 = 0; i2 < n2 && inner[j2].id != startId; ++i2) {
                        if (++j2 != n2) continue;
                        j2 = 0;
                    }
                    index = j2;
                    this.lastIndex = j2;
                    this.lastId = inner[j2].id;
                }
                j2 = index;
                block6: for (i2 = 0; i2 < n2; ++i2) {
                    if (this.checkTerminate()) {
                        return;
                    }
                    FlowableFlatMap$InnerSubscriber<?, ?> is2 = inner[j2];
                    Object o3 = null;
                    do {
                        if (this.checkTerminate()) {
                            return;
                        }
                        SimpleQueue q2 = is2.queue;
                        if (q2 == null) break;
                        long produced = 0L;
                        while (r2 != 0L) {
                            try {
                                o3 = q2.poll();
                            }
                            catch (Throwable ex3) {
                                Exceptions.throwIfFatal(ex3);
                                is2.dispose();
                                this.errs.addThrowable(ex3);
                                if (!this.delayErrors) {
                                    this.upstream.cancel();
                                }
                                if (this.checkTerminate()) {
                                    return;
                                }
                                this.removeInner(is2);
                                innerCompleted = true;
                                ++i2;
                                continue block6;
                            }
                            if (o3 == null) break;
                            child.onNext(o3);
                            if (this.checkTerminate()) {
                                return;
                            }
                            --r2;
                            ++produced;
                        }
                        if (produced == 0L) continue;
                        r2 = !unbounded ? this.requested.addAndGet(-produced) : Long.MAX_VALUE;
                        is2.requestMore(produced);
                    } while (r2 != 0L && o3 != null);
                    boolean innerDone = is2.done;
                    SimpleQueue innerQueue = is2.queue;
                    if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                        this.removeInner(is2);
                        if (this.checkTerminate()) {
                            return;
                        }
                        ++replenishMain;
                        innerCompleted = true;
                    }
                    if (r2 == 0L) break;
                    if (++j2 != n2) continue;
                    j2 = 0;
                }
                this.lastIndex = j2;
                this.lastId = inner[j2].id;
            }
            if (replenishMain == 0L || this.cancelled) continue;
            this.upstream.request(replenishMain);
        } while (innerCompleted || (missed = this.addAndGet(-missed)) != 0);
    }

    boolean checkTerminate() {
        if (this.cancelled) {
            this.clearScalarQueue();
            return true;
        }
        if (!this.delayErrors && this.errs.get() != null) {
            this.clearScalarQueue();
            Throwable ex2 = this.errs.terminate();
            if (ex2 != ExceptionHelper.TERMINATED) {
                this.actual.onError(ex2);
            }
            return true;
        }
        return false;
    }

    void clearScalarQueue() {
        SimplePlainQueue<U> q2 = this.queue;
        if (q2 != null) {
            q2.clear();
        }
    }

    void disposeAll() {
        FlowableFlatMap$InnerSubscriber<?, ?>[] a2 = this.subscribers.get();
        if (a2 != CANCELLED && (a2 = this.subscribers.getAndSet(CANCELLED)) != CANCELLED) {
            for (FlowableFlatMap$InnerSubscriber<?, ?> inner : a2) {
                inner.dispose();
            }
            Throwable ex2 = this.errs.terminate();
            if (ex2 != null && ex2 != ExceptionHelper.TERMINATED) {
                RxJavaPlugins.onError(ex2);
            }
        }
    }

    void innerError(FlowableFlatMap$InnerSubscriber<T, U> inner, Throwable t2) {
        if (this.errs.addThrowable(t2)) {
            inner.done = true;
            if (!this.delayErrors) {
                this.upstream.cancel();
                for (FlowableFlatMap$InnerSubscriber<?, ?> a2 : this.subscribers.getAndSet(CANCELLED)) {
                    a2.dispose();
                }
            }
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }
}

