/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;

final class FlowableDoFinally$DoFinallySubscriber<T>
extends BasicIntQueueSubscription<T>
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = 4109457741734051389L;
    final Yx<? super T> actual;
    final Action onFinally;
    Yy s;
    QueueSubscription<T> qs;
    boolean syncFused;

    FlowableDoFinally$DoFinallySubscriber(Yx<? super T> actual, Action onFinally) {
        this.actual = actual;
        this.onFinally = onFinally;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            if (s2 instanceof QueueSubscription) {
                this.qs = (QueueSubscription)s2;
            }
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t2) {
        this.actual.onNext(t2);
    }

    @Override
    public void onError(Throwable t2) {
        this.actual.onError(t2);
        this.runFinally();
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
        this.runFinally();
    }

    @Override
    public void cancel() {
        this.s.cancel();
        this.runFinally();
    }

    @Override
    public void request(long n2) {
        this.s.request(n2);
    }

    @Override
    public int requestFusion(int mode) {
        QueueSubscription<T> qs2 = this.qs;
        if (qs2 != null && (mode & 4) == 0) {
            int m2 = qs2.requestFusion(mode);
            if (m2 != 0) {
                this.syncFused = m2 == 1;
            }
            return m2;
        }
        return 0;
    }

    @Override
    public void clear() {
        this.qs.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.qs.isEmpty();
    }

    @Override
    @Nullable
    public T poll() {
        Object v2 = this.qs.poll();
        if (v2 == null && this.syncFused) {
            this.runFinally();
        }
        return v2;
    }

    void runFinally() {
        if (this.compareAndSet(0, 1)) {
            try {
                this.onFinally.run();
            }
            catch (Throwable ex2) {
                Exceptions.throwIfFatal(ex2);
                RxJavaPlugins.onError(ex2);
            }
        }
    }
}

