/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler$Worker;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.flowable.FlowableDebounceTimed$DebounceEmitter;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableDebounceTimed$DebounceTimedSubscriber<T>
extends AtomicLong
implements Yy,
FlowableSubscriber<T> {
    private static final long serialVersionUID = -9102637559663639004L;
    final Yx<? super T> actual;
    final long timeout;
    final TimeUnit unit;
    final Scheduler$Worker worker;
    Yy s;
    final SequentialDisposable timer = new SequentialDisposable();
    volatile long index;
    boolean done;

    FlowableDebounceTimed$DebounceTimedSubscriber(Yx<? super T> actual, long timeout, TimeUnit unit, Scheduler$Worker worker) {
        this.actual = actual;
        this.timeout = timeout;
        this.unit = unit;
        this.worker = worker;
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T t2) {
        FlowableDebounceTimed$DebounceEmitter<T> de2;
        long idx;
        if (this.done) {
            return;
        }
        this.index = idx = this.index + 1L;
        Disposable d2 = (Disposable)this.timer.get();
        if (d2 != null) {
            d2.dispose();
        }
        if (this.timer.replace(de2 = new FlowableDebounceTimed$DebounceEmitter<T>(t2, idx, this))) {
            d2 = this.worker.schedule(de2, this.timeout, this.unit);
            de2.setResource(d2);
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done) {
            RxJavaPlugins.onError(t2);
            return;
        }
        this.done = true;
        this.actual.onError(t2);
        this.worker.dispose();
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Disposable d2 = (Disposable)this.timer.get();
        if (!DisposableHelper.isDisposed(d2)) {
            FlowableDebounceTimed$DebounceEmitter de2 = (FlowableDebounceTimed$DebounceEmitter)d2;
            if (de2 != null) {
                de2.emit();
            }
            DisposableHelper.dispose(this.timer);
            this.actual.onComplete();
            this.worker.dispose();
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this, n2);
        }
    }

    @Override
    public void cancel() {
        this.s.cancel();
        this.worker.dispose();
    }

    void emit(long idx, T t2, FlowableDebounceTimed$DebounceEmitter<T> emitter) {
        if (idx == this.index) {
            long r2 = this.get();
            if (r2 != 0L) {
                this.actual.onNext(t2);
                BackpressureHelper.produced(this, 1L);
                emitter.dispose();
            } else {
                this.cancel();
                this.actual.onError(new MissingBackpressureException("Could not deliver value due to lack of requests"));
            }
        }
    }
}

