/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.operators.flowable.FlowableCreate$BaseEmitter;
import io.reactivex.internal.operators.flowable.FlowableCreate$BufferAsyncEmitter;
import io.reactivex.internal.operators.flowable.FlowableCreate$DropAsyncEmitter;
import io.reactivex.internal.operators.flowable.FlowableCreate$ErrorAsyncEmitter;
import io.reactivex.internal.operators.flowable.FlowableCreate$LatestAsyncEmitter;
import io.reactivex.internal.operators.flowable.FlowableCreate$MissingEmitter;

public final class FlowableCreate<T>
extends Flowable<T> {
    final FlowableOnSubscribe<T> source;
    final BackpressureStrategy backpressure;

    public FlowableCreate(FlowableOnSubscribe<T> source, BackpressureStrategy backpressure) {
        this.source = source;
        this.backpressure = backpressure;
    }

    @Override
    public void subscribeActual(Yx<? super T> t2) {
        FlowableCreate$BaseEmitter emitter;
        switch (this.backpressure) {
            case MISSING: {
                emitter = new FlowableCreate$MissingEmitter<T>(t2);
                break;
            }
            case ERROR: {
                emitter = new FlowableCreate$ErrorAsyncEmitter<T>(t2);
                break;
            }
            case DROP: {
                emitter = new FlowableCreate$DropAsyncEmitter<T>(t2);
                break;
            }
            case LATEST: {
                emitter = new FlowableCreate$LatestAsyncEmitter<T>(t2);
                break;
            }
            default: {
                emitter = new FlowableCreate$BufferAsyncEmitter<T>(t2, FlowableCreate.bufferSize());
            }
        }
        t2.onSubscribe(emitter);
        try {
            this.source.subscribe(emitter);
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            emitter.onError(ex2);
        }
    }
}

