/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.FlowableCreate$BaseEmitter;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class FlowableCreate$LatestAsyncEmitter<T>
extends FlowableCreate$BaseEmitter<T> {
    private static final long serialVersionUID = 4023437720691792495L;
    final AtomicReference<T> queue = new AtomicReference();
    Throwable error;
    volatile boolean done;
    final AtomicInteger wip = new AtomicInteger();

    FlowableCreate$LatestAsyncEmitter(Yx<? super T> actual) {
        super(actual);
    }

    @Override
    public void onNext(T t2) {
        if (this.done || this.isCancelled()) {
            return;
        }
        if (t2 == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        this.queue.set(t2);
        this.drain();
    }

    @Override
    public boolean tryOnError(Throwable e2) {
        if (this.done || this.isCancelled()) {
            return false;
        }
        if (e2 == null) {
            this.onError(new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources."));
        }
        this.error = e2;
        this.done = true;
        this.drain();
        return true;
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    void onRequested() {
        this.drain();
    }

    @Override
    void onUnsubscribed() {
        if (this.wip.getAndIncrement() == 0) {
            this.queue.lazySet(null);
        }
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx a2 = this.actual;
        AtomicReference<T> q2 = this.queue;
        do {
            boolean d2;
            long e2;
            long r2 = this.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                boolean empty;
                if (this.isCancelled()) {
                    q2.lazySet(null);
                    return;
                }
                d2 = this.done;
                Object o2 = q2.getAndSet(null);
                boolean bl2 = empty = o2 == null;
                if (d2 && empty) {
                    Throwable ex2 = this.error;
                    if (ex2 != null) {
                        this.error(ex2);
                    } else {
                        this.complete();
                    }
                    return;
                }
                if (empty) break;
                a2.onNext(o2);
            }
            if (e2 == r2) {
                boolean empty;
                if (this.isCancelled()) {
                    q2.lazySet(null);
                    return;
                }
                d2 = this.done;
                boolean bl3 = empty = q2.get() == null;
                if (d2 && empty) {
                    Throwable ex3 = this.error;
                    if (ex3 != null) {
                        this.error(ex3);
                    } else {
                        this.complete();
                    }
                    return;
                }
            }
            if (e2 == 0L) continue;
            BackpressureHelper.produced(this, e2);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }
}

