/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.FlowableCreate$BaseEmitter;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;

final class FlowableCreate$BufferAsyncEmitter<T>
extends FlowableCreate$BaseEmitter<T> {
    private static final long serialVersionUID = 2427151001689639875L;
    final SpscLinkedArrayQueue<T> queue;
    Throwable error;
    volatile boolean done;
    final AtomicInteger wip;

    FlowableCreate$BufferAsyncEmitter(Yx<? super T> actual, int capacityHint) {
        super(actual);
        this.queue = new SpscLinkedArrayQueue(capacityHint);
        this.wip = new AtomicInteger();
    }

    @Override
    public void onNext(T t2) {
        if (this.done || this.isCancelled()) {
            return;
        }
        if (t2 == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        this.queue.offer(t2);
        this.drain();
    }

    @Override
    public boolean tryOnError(Throwable e2) {
        if (this.done || this.isCancelled()) {
            return false;
        }
        if (e2 == null) {
            e2 = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        this.error = e2;
        this.done = true;
        this.drain();
        return true;
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    void onRequested() {
        this.drain();
    }

    @Override
    void onUnsubscribed() {
        if (this.wip.getAndIncrement() == 0) {
            this.queue.clear();
        }
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        Yx a2 = this.actual;
        SpscLinkedArrayQueue<T> q2 = this.queue;
        do {
            boolean d2;
            long e2;
            long r2 = this.get();
            for (e2 = 0L; e2 != r2; ++e2) {
                boolean empty;
                if (this.isCancelled()) {
                    q2.clear();
                    return;
                }
                d2 = this.done;
                T o2 = q2.poll();
                boolean bl2 = empty = o2 == null;
                if (d2 && empty) {
                    Throwable ex2 = this.error;
                    if (ex2 != null) {
                        this.error(ex2);
                    } else {
                        this.complete();
                    }
                    return;
                }
                if (empty) break;
                a2.onNext(o2);
            }
            if (e2 == r2) {
                if (this.isCancelled()) {
                    q2.clear();
                    return;
                }
                d2 = this.done;
                boolean empty = q2.isEmpty();
                if (d2 && empty) {
                    Throwable ex3 = this.error;
                    if (ex3 != null) {
                        this.error(ex3);
                    } else {
                        this.complete();
                    }
                    return;
                }
            }
            if (e2 == 0L) continue;
            BackpressureHelper.produced(this, e2);
        } while ((missed = this.wip.addAndGet(-missed)) != 0);
    }
}

