/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscribers.InnerQueuedSubscriber;
import io.reactivex.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class FlowableConcatMapEager$ConcatMapEagerDelayErrorSubscriber<T, R>
extends AtomicInteger
implements Yy,
FlowableSubscriber<T>,
InnerQueuedSubscriberSupport<R> {
    private static final long serialVersionUID = -4255299542215038287L;
    final Yx<? super R> actual;
    final Function<? super T, ? extends Yw<? extends R>> mapper;
    final int maxConcurrency;
    final int prefetch;
    final ErrorMode errorMode;
    final AtomicThrowable errors;
    final AtomicLong requested;
    final SpscLinkedArrayQueue<InnerQueuedSubscriber<R>> subscribers;
    Yy s;
    volatile boolean cancelled;
    volatile boolean done;
    volatile InnerQueuedSubscriber<R> current;

    FlowableConcatMapEager$ConcatMapEagerDelayErrorSubscriber(Yx<? super R> actual, Function<? super T, ? extends Yw<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
        this.actual = actual;
        this.mapper = mapper;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
        this.subscribers = new SpscLinkedArrayQueue(Math.min(prefetch, maxConcurrency));
        this.errors = new AtomicThrowable();
        this.requested = new AtomicLong();
    }

    @Override
    public void onSubscribe(Yy s2) {
        if (SubscriptionHelper.validate(this.s, s2)) {
            this.s = s2;
            this.actual.onSubscribe(this);
            s2.request(this.maxConcurrency == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.maxConcurrency);
        }
    }

    @Override
    public void onNext(T t2) {
        Yw<R> p2;
        try {
            p2 = ObjectHelper.requireNonNull(this.mapper.apply(t2), "The mapper returned a null Publisher");
        }
        catch (Throwable ex2) {
            Exceptions.throwIfFatal(ex2);
            this.s.cancel();
            this.onError(ex2);
            return;
        }
        InnerQueuedSubscriber inner = new InnerQueuedSubscriber(this, this.prefetch);
        if (this.cancelled) {
            return;
        }
        this.subscribers.offer(inner);
        if (this.cancelled) {
            return;
        }
        p2.subscribe(inner);
        if (this.cancelled) {
            inner.cancel();
            this.drainAndCancel();
        }
    }

    @Override
    public void onError(Throwable t2) {
        if (this.errors.addThrowable(t2)) {
            this.done = true;
            this.drain();
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void onComplete() {
        this.done = true;
        this.drain();
    }

    @Override
    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.s.cancel();
        this.drainAndCancel();
    }

    void drainAndCancel() {
        if (this.getAndIncrement() == 0) {
            do {
                this.cancelAll();
            } while (this.decrementAndGet() != 0);
        }
    }

    void cancelAll() {
        InnerQueuedSubscriber<R> inner;
        while ((inner = this.subscribers.poll()) != null) {
            inner.cancel();
        }
    }

    @Override
    public void request(long n2) {
        if (SubscriptionHelper.validate(n2)) {
            BackpressureHelper.add(this.requested, n2);
            this.drain();
        }
    }

    @Override
    public void innerNext(InnerQueuedSubscriber<R> inner, R value) {
        if (inner.queue().offer(value)) {
            this.drain();
        } else {
            inner.cancel();
            this.innerError(inner, (Throwable)new MissingBackpressureException());
        }
    }

    @Override
    public void innerError(InnerQueuedSubscriber<R> inner, Throwable e2) {
        if (this.errors.addThrowable(e2)) {
            inner.setDone();
            if (this.errorMode != ErrorMode.END) {
                this.s.cancel();
            }
            this.drain();
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void innerComplete(InnerQueuedSubscriber<R> inner) {
        inner.setDone();
        this.drain();
    }

    @Override
    public void drain() {
        boolean continueNextSource;
        if (this.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        InnerQueuedSubscriber<R> inner = this.current;
        Yx<R> a2 = this.actual;
        ErrorMode em2 = this.errorMode;
        do {
            SimpleQueue<R> q2;
            long r2 = this.requested.get();
            long e2 = 0L;
            if (inner == null) {
                Throwable ex2;
                if (em2 != ErrorMode.END && (ex2 = (Throwable)this.errors.get()) != null) {
                    this.cancelAll();
                    a2.onError(this.errors.terminate());
                    return;
                }
                boolean outerDone = this.done;
                inner = this.subscribers.poll();
                if (outerDone && inner == null) {
                    Throwable ex3 = this.errors.terminate();
                    if (ex3 != null) {
                        a2.onError(ex3);
                    } else {
                        a2.onComplete();
                    }
                    return;
                }
                if (inner != null) {
                    this.current = inner;
                }
            }
            continueNextSource = false;
            if (inner != null && (q2 = inner.queue()) != null) {
                boolean d2;
                while (e2 != r2) {
                    boolean empty;
                    R v2;
                    Throwable ex4;
                    if (this.cancelled) {
                        this.cancelAll();
                        return;
                    }
                    if (em2 == ErrorMode.IMMEDIATE && (ex4 = (Throwable)this.errors.get()) != null) {
                        this.current = null;
                        inner.cancel();
                        this.cancelAll();
                        a2.onError(this.errors.terminate());
                        return;
                    }
                    d2 = inner.isDone();
                    try {
                        v2 = q2.poll();
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        this.current = null;
                        inner.cancel();
                        this.cancelAll();
                        a2.onError(ex5);
                        return;
                    }
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        inner = null;
                        this.current = null;
                        this.s.request(1L);
                        continueNextSource = true;
                        break;
                    }
                    if (empty) break;
                    a2.onNext(v2);
                    ++e2;
                    inner.requestOne();
                }
                if (e2 == r2) {
                    Throwable ex6;
                    if (this.cancelled) {
                        this.cancelAll();
                        return;
                    }
                    if (em2 == ErrorMode.IMMEDIATE && (ex6 = (Throwable)this.errors.get()) != null) {
                        this.current = null;
                        inner.cancel();
                        this.cancelAll();
                        a2.onError(this.errors.terminate());
                        return;
                    }
                    d2 = inner.isDone();
                    boolean empty = q2.isEmpty();
                    if (d2 && empty) {
                        inner = null;
                        this.current = null;
                        this.s.request(1L);
                        continueNextSource = true;
                    }
                }
            }
            if (e2 == 0L || r2 == Long.MAX_VALUE) continue;
            this.requested.addAndGet(-e2);
        } while (continueNextSource || (missed = this.addAndGet(-missed)) != 0);
    }
}

