/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableConcatMap$ConcatMapDelayed;
import io.reactivex.internal.operators.flowable.FlowableConcatMap$ConcatMapImmediate;
import io.reactivex.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.internal.util.ErrorMode;

public final class FlowableConcatMap<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Yw<? extends R>> mapper;
    final int prefetch;
    final ErrorMode errorMode;

    public FlowableConcatMap(Flowable<T> source, Function<? super T, ? extends Yw<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        super(source);
        this.mapper = mapper;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    public static <T, R> Yx<T> subscribe(Yx<? super R> s2, Function<? super T, ? extends Yw<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        switch (errorMode) {
            case BOUNDARY: {
                return new FlowableConcatMap$ConcatMapDelayed<T, R>(s2, mapper, prefetch, false);
            }
            case END: {
                return new FlowableConcatMap$ConcatMapDelayed<T, R>(s2, mapper, prefetch, true);
            }
        }
        return new FlowableConcatMap$ConcatMapImmediate<T, R>(s2, mapper, prefetch);
    }

    @Override
    public void subscribeActual(Yx<? super R> s2) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s2, this.mapper)) {
            return;
        }
        this.source.subscribe(FlowableConcatMap.subscribe(s2, this.mapper, this.prefetch, this.errorMode));
    }
}

