/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableConcatMap$BaseConcatMapSubscriber;
import io.reactivex.internal.operators.flowable.FlowableConcatMap$WeakScalarSubscription;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

final class FlowableConcatMap$ConcatMapImmediate<T, R>
extends FlowableConcatMap$BaseConcatMapSubscriber<T, R> {
    private static final long serialVersionUID = 7898995095634264146L;
    final Yx<? super R> actual;
    final AtomicInteger wip;

    FlowableConcatMap$ConcatMapImmediate(Yx<? super R> actual, Function<? super T, ? extends Yw<? extends R>> mapper, int prefetch) {
        super(mapper, prefetch);
        this.actual = actual;
        this.wip = new AtomicInteger();
    }

    @Override
    void subscribeActual() {
        this.actual.onSubscribe(this);
    }

    @Override
    public void onError(Throwable t2) {
        if (this.errors.addThrowable(t2)) {
            this.inner.cancel();
            if (this.getAndIncrement() == 0) {
                this.actual.onError(this.errors.terminate());
            }
        } else {
            RxJavaPlugins.onError(t2);
        }
    }

    @Override
    public void innerNext(R value) {
        if (this.get() == 0 && this.compareAndSet(0, 1)) {
            this.actual.onNext(value);
            if (this.compareAndSet(1, 0)) {
                return;
            }
            this.actual.onError(this.errors.terminate());
        }
    }

    @Override
    public void innerError(Throwable e2) {
        if (this.errors.addThrowable(e2)) {
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.actual.onError(this.errors.terminate());
            }
        } else {
            RxJavaPlugins.onError(e2);
        }
    }

    @Override
    public void request(long n2) {
        this.inner.request(n2);
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.inner.cancel();
            this.s.cancel();
        }
    }

    @Override
    void drain() {
        block17: {
            if (this.wip.getAndIncrement() != 0) break block17;
            while (true) {
                if (this.cancelled) {
                    return;
                }
                if (!this.active) {
                    boolean empty;
                    Object v2;
                    boolean d2 = this.done;
                    try {
                        v2 = this.queue.poll();
                    }
                    catch (Throwable e2) {
                        Exceptions.throwIfFatal(e2);
                        this.s.cancel();
                        this.errors.addThrowable(e2);
                        this.actual.onError(this.errors.terminate());
                        return;
                    }
                    boolean bl2 = empty = v2 == null;
                    if (d2 && empty) {
                        this.actual.onComplete();
                        return;
                    }
                    if (!empty) {
                        Yw p2;
                        try {
                            p2 = (Yw)ObjectHelper.requireNonNull(this.mapper.apply(v2), "The mapper returned a null Publisher");
                        }
                        catch (Throwable e3) {
                            Exceptions.throwIfFatal(e3);
                            this.s.cancel();
                            this.errors.addThrowable(e3);
                            this.actual.onError(this.errors.terminate());
                            return;
                        }
                        if (this.sourceMode != 1) {
                            int c2 = this.consumed + 1;
                            if (c2 == this.limit) {
                                this.consumed = 0;
                                this.s.request(c2);
                            } else {
                                this.consumed = c2;
                            }
                        }
                        if (p2 instanceof Callable) {
                            Object vr2;
                            Callable callable = (Callable)((Object)p2);
                            try {
                                vr2 = callable.call();
                            }
                            catch (Throwable e4) {
                                Exceptions.throwIfFatal(e4);
                                this.s.cancel();
                                this.errors.addThrowable(e4);
                                this.actual.onError(this.errors.terminate());
                                return;
                            }
                            if (vr2 == null) continue;
                            if (this.inner.isUnbounded()) {
                                if (this.get() != 0 || !this.compareAndSet(0, 1)) continue;
                                this.actual.onNext(vr2);
                                if (this.compareAndSet(1, 0)) continue;
                                this.actual.onError(this.errors.terminate());
                                return;
                            }
                            this.active = true;
                            this.inner.setSubscription(new FlowableConcatMap$WeakScalarSubscription(vr2, this.inner));
                        } else {
                            this.active = true;
                            p2.subscribe(this.inner);
                        }
                    }
                }
                if (this.wip.decrementAndGet() == 0) break;
            }
        }
    }
}

