/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableCache$CacheState;
import io.reactivex.internal.operators.flowable.FlowableCache$ReplaySubscription;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FlowableCache<T>
extends AbstractFlowableWithUpstream<T, T> {
    final FlowableCache$CacheState<T> state;
    final AtomicBoolean once;

    public FlowableCache(Flowable<T> source, int capacityHint) {
        super(source);
        this.state = new FlowableCache$CacheState<T>(source, capacityHint);
        this.once = new AtomicBoolean();
    }

    @Override
    public void subscribeActual(Yx<? super T> t2) {
        FlowableCache$ReplaySubscription<? super T> rp2 = new FlowableCache$ReplaySubscription<T>(t2, this.state);
        this.state.addChild(rp2);
        t2.onSubscribe(rp2);
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            this.state.connect();
        }
    }

    boolean isConnected() {
        return this.state.isConnected;
    }

    boolean hasSubscribers() {
        return this.state.subscribers.get().length != 0;
    }

    int cachedEventCount() {
        return this.state.size();
    }
}

